rule win_jlorat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.jlorat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jlorat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? e9???????? 89e0 8d4d0c 8908 e8???????? 899558ffffff }
            // n = 7, score = 200
            //   e8????????           |                     
            //   e9????????           |                     
            //   89e0                 | mov                 eax, esp
            //   8d4d0c               | lea                 ecx, [ebp + 0xc]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   e8????????           |                     
            //   899558ffffff         | mov                 dword ptr [ebp - 0xa8], edx

        $sequence_1 = { eb00 8b4de0 83c134 c745f0ffffffff 89e0 8908 e8???????? }
            // n = 7, score = 200
            //   eb00                 | jmp                 2
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   83c134               | add                 ecx, 0x34
            //   c745f0ffffffff       | mov                 dword ptr [ebp - 0x10], 0xffffffff
            //   89e0                 | mov                 eax, esp
            //   8908                 | mov                 dword ptr [eax], ecx
            //   e8????????           |                     

        $sequence_2 = { f7e2 8985d0feffff 8995d4feffff b804000000 c1e002 8b4d0c ba04000000 }
            // n = 7, score = 200
            //   f7e2                 | mul                 edx
            //   8985d0feffff         | mov                 dword ptr [ebp - 0x130], eax
            //   8995d4feffff         | mov                 dword ptr [ebp - 0x12c], edx
            //   b804000000           | mov                 eax, 4
            //   c1e002               | shl                 eax, 2
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   ba04000000           | mov                 edx, 4

        $sequence_3 = { eb00 8b8d7cffffff 8b45b0 894de0 0518040000 898574ffffff c745cc01000000 }
            // n = 7, score = 200
            //   eb00                 | jmp                 2
            //   8b8d7cffffff         | mov                 ecx, dword ptr [ebp - 0x84]
            //   8b45b0               | mov                 eax, dword ptr [ebp - 0x50]
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   0518040000           | add                 eax, 0x418
            //   898574ffffff         | mov                 dword ptr [ebp - 0x8c], eax
            //   c745cc01000000       | mov                 dword ptr [ebp - 0x34], 1

        $sequence_4 = { e8???????? 8995c8feffff 8985ccfeffff eb00 8b8dc4feffff 8b85c8feffff 8b95ccfeffff }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8995c8feffff         | mov                 dword ptr [ebp - 0x138], edx
            //   8985ccfeffff         | mov                 dword ptr [ebp - 0x134], eax
            //   eb00                 | jmp                 2
            //   8b8dc4feffff         | mov                 ecx, dword ptr [ebp - 0x13c]
            //   8b85c8feffff         | mov                 eax, dword ptr [ebp - 0x138]
            //   8b95ccfeffff         | mov                 edx, dword ptr [ebp - 0x134]

        $sequence_5 = { eb5f eb00 b801000000 83f800 7514 8b442438 8b00 }
            // n = 7, score = 200
            //   eb5f                 | jmp                 0x61
            //   eb00                 | jmp                 2
            //   b801000000           | mov                 eax, 1
            //   83f800               | cmp                 eax, 0
            //   7514                 | jne                 0x16
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_6 = { e8???????? eb00 8b4da4 83c10c c745f001000000 89e0 8d55cc }
            // n = 7, score = 200
            //   e8????????           |                     
            //   eb00                 | jmp                 2
            //   8b4da4               | mov                 ecx, dword ptr [ebp - 0x5c]
            //   83c10c               | add                 ecx, 0xc
            //   c745f001000000       | mov                 dword ptr [ebp - 0x10], 1
            //   89e0                 | mov                 eax, esp
            //   8d55cc               | lea                 edx, [ebp - 0x34]

        $sequence_7 = { eb2a 8b4e14 8b5618 89e0 895004 8908 e8???????? }
            // n = 7, score = 200
            //   eb2a                 | jmp                 0x2c
            //   8b4e14               | mov                 ecx, dword ptr [esi + 0x14]
            //   8b5618               | mov                 edx, dword ptr [esi + 0x18]
            //   89e0                 | mov                 eax, esp
            //   895004               | mov                 dword ptr [eax + 4], edx
            //   8908                 | mov                 dword ptr [eax], ecx
            //   e8????????           |                     

        $sequence_8 = { f20f1186b8010000 f20f108698010000 f20f1186d8010000 f20f108688010000 f20f108e90010000 f20f118ed0010000 f20f1186c8010000 }
            // n = 7, score = 200
            //   f20f1186b8010000     | movsd               qword ptr [esi + 0x1b8], xmm0
            //   f20f108698010000     | movsd               xmm0, qword ptr [esi + 0x198]
            //   f20f1186d8010000     | movsd               qword ptr [esi + 0x1d8], xmm0
            //   f20f108688010000     | movsd               xmm0, qword ptr [esi + 0x188]
            //   f20f108e90010000     | movsd               xmm1, qword ptr [esi + 0x190]
            //   f20f118ed0010000     | movsd               qword ptr [esi + 0x1d0], xmm1
            //   f20f1186c8010000     | movsd               qword ptr [esi + 0x1c8], xmm0

        $sequence_9 = { f20f1145d0 c745f001000000 89e0 8d55d0 895004 8908 e8???????? }
            // n = 7, score = 200
            //   f20f1145d0           | movsd               qword ptr [ebp - 0x30], xmm0
            //   c745f001000000       | mov                 dword ptr [ebp - 0x10], 1
            //   89e0                 | mov                 eax, esp
            //   8d55d0               | lea                 edx, [ebp - 0x30]
            //   895004               | mov                 dword ptr [eax + 4], edx
            //   8908                 | mov                 dword ptr [eax], ecx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 10952704
}