rule win_jolob_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.jolob."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jolob"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a64 ff15???????? e9???????? 8b431c e8???????? ff7318 e8???????? }
            // n = 7, score = 300
            //   6a64                 | push                0x64
            //   ff15????????         |                     
            //   e9????????           |                     
            //   8b431c               | mov                 eax, dword ptr [ebx + 0x1c]
            //   e8????????           |                     
            //   ff7318               | push                dword ptr [ebx + 0x18]
            //   e8????????           |                     

        $sequence_1 = { ff15???????? 50 ff15???????? 8d85ecfeffff 50 ff15???????? 85c0 }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d85ecfeffff         | lea                 eax, [ebp - 0x114]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { 3bc2 75ec 834710f8 8d75dc e8???????? ff75f4 ff15???????? }
            // n = 7, score = 300
            //   3bc2                 | cmp                 eax, edx
            //   75ec                 | jne                 0xffffffee
            //   834710f8             | add                 dword ptr [edi + 0x10], -8
            //   8d75dc               | lea                 esi, [ebp - 0x24]
            //   e8????????           |                     
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff15????????         |                     

        $sequence_3 = { 832600 59 8bb720080000 8b2d???????? 85f6 7415 }
            // n = 6, score = 300
            //   832600               | and                 dword ptr [esi], 0
            //   59                   | pop                 ecx
            //   8bb720080000         | mov                 esi, dword ptr [edi + 0x820]
            //   8b2d????????         |                     
            //   85f6                 | test                esi, esi
            //   7415                 | je                  0x17

        $sequence_4 = { 8945e4 e8???????? 8b5de4 8b4f0c 53 }
            // n = 5, score = 300
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   e8????????           |                     
            //   8b5de4               | mov                 ebx, dword ptr [ebp - 0x1c]
            //   8b4f0c               | mov                 ecx, dword ptr [edi + 0xc]
            //   53                   | push                ebx

        $sequence_5 = { 8a45ff 88043e 46 83fe04 7c1f 807c3efc0d 7518 }
            // n = 7, score = 300
            //   8a45ff               | mov                 al, byte ptr [ebp - 1]
            //   88043e               | mov                 byte ptr [esi + edi], al
            //   46                   | inc                 esi
            //   83fe04               | cmp                 esi, 4
            //   7c1f                 | jl                  0x21
            //   807c3efc0d           | cmp                 byte ptr [esi + edi - 4], 0xd
            //   7518                 | jne                 0x1a

        $sequence_6 = { 8bc6 5e c20400 832700 85f6 7410 8b4618 }
            // n = 7, score = 300
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c20400               | ret                 4
            //   832700               | and                 dword ptr [edi], 0
            //   85f6                 | test                esi, esi
            //   7410                 | je                  0x12
            //   8b4618               | mov                 eax, dword ptr [esi + 0x18]

        $sequence_7 = { 8d7df4 e8???????? 8b45f4 8906 5f c9 c3 }
            // n = 7, score = 300
            //   8d7df4               | lea                 edi, [ebp - 0xc]
            //   e8????????           |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8906                 | mov                 dword ptr [esi], eax
            //   5f                   | pop                 edi
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_8 = { 3b4e30 72e9 8918 8b463c }
            // n = 4, score = 300
            //   3b4e30               | cmp                 ecx, dword ptr [esi + 0x30]
            //   72e9                 | jb                  0xffffffeb
            //   8918                 | mov                 dword ptr [eax], ebx
            //   8b463c               | mov                 eax, dword ptr [esi + 0x3c]

        $sequence_9 = { 3bc3 7407 50 e8???????? 59 895e14 895e10 }
            // n = 7, score = 300
            //   3bc3                 | cmp                 eax, ebx
            //   7407                 | je                  9
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   895e14               | mov                 dword ptr [esi + 0x14], ebx
            //   895e10               | mov                 dword ptr [esi + 0x10], ebx

    condition:
        7 of them and filesize < 196608
}