rule win_jripbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.jripbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jripbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 51 50 0fbf45ee 50 be???????? e8???????? }
            // n = 7, score = 100
            //   52                   | push                edx
            //   51                   | push                ecx
            //   50                   | push                eax
            //   0fbf45ee             | movsx               eax, word ptr [ebp - 0x12]
            //   50                   | push                eax
            //   be????????           |                     
            //   e8????????           |                     

        $sequence_1 = { 50 ff15???????? eb61 ff742434 8d842464010000 ff742414 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   eb61                 | jmp                 0x63
            //   ff742434             | push                dword ptr [esp + 0x34]
            //   8d842464010000       | lea                 eax, [esp + 0x164]
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   e8????????           |                     

        $sequence_2 = { 7436 830804 f6c302 742e 56 ff15???????? 50 }
            // n = 7, score = 100
            //   7436                 | je                  0x38
            //   830804               | or                  dword ptr [eax], 4
            //   f6c302               | test                bl, 2
            //   742e                 | je                  0x30
            //   56                   | push                esi
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_3 = { 8d85a8fcffff 8d5001 8a08 40 3acb 75f9 2bc2 }
            // n = 7, score = 100
            //   8d85a8fcffff         | lea                 eax, [ebp - 0x358]
            //   8d5001               | lea                 edx, [eax + 1]
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   3acb                 | cmp                 cl, bl
            //   75f9                 | jne                 0xfffffffb
            //   2bc2                 | sub                 eax, edx

        $sequence_4 = { 50 8d442418 50 894c2420 ff15???????? 83c40c 85c0 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   50                   | push                eax
            //   894c2420             | mov                 dword ptr [esp + 0x20], ecx
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax

        $sequence_5 = { 6a30 ff750c 8d75fc 8bcf e8???????? 83c408 }
            // n = 6, score = 100
            //   6a30                 | push                0x30
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8d75fc               | lea                 esi, [ebp - 4]
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_6 = { 8b8de0fdffff 8bc3 668b10 663b11 751e 663bd7 7415 }
            // n = 7, score = 100
            //   8b8de0fdffff         | mov                 ecx, dword ptr [ebp - 0x220]
            //   8bc3                 | mov                 eax, ebx
            //   668b10               | mov                 dx, word ptr [eax]
            //   663b11               | cmp                 dx, word ptr [ecx]
            //   751e                 | jne                 0x20
            //   663bd7               | cmp                 dx, di
            //   7415                 | je                  0x17

        $sequence_7 = { 33fb 037dfc 8b5ddc 235df4 0bf3 03f7 8b7d88 }
            // n = 7, score = 100
            //   33fb                 | xor                 edi, ebx
            //   037dfc               | add                 edi, dword ptr [ebp - 4]
            //   8b5ddc               | mov                 ebx, dword ptr [ebp - 0x24]
            //   235df4               | and                 ebx, dword ptr [ebp - 0xc]
            //   0bf3                 | or                  esi, ebx
            //   03f7                 | add                 esi, edi
            //   8b7d88               | mov                 edi, dword ptr [ebp - 0x78]

        $sequence_8 = { 8bf8 83c40c 85ff 0f85da000000 ff742410 8d442448 e8???????? }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   83c40c               | add                 esp, 0xc
            //   85ff                 | test                edi, edi
            //   0f85da000000         | jne                 0xe0
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   8d442448             | lea                 eax, [esp + 0x48]
            //   e8????????           |                     

        $sequence_9 = { 8d443718 50 e8???????? 83c40c 8d4618 8bce e8???????? }
            // n = 7, score = 100
            //   8d443718             | lea                 eax, [edi + esi + 0x18]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d4618               | lea                 eax, [esi + 0x18]
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 507904
}