rule win_jssloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.jssloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jssloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3d55555515 0f846b010000 8b4b08 8d7001 2bcf b8abaaaa2a f7e9 }
            // n = 7, score = 200
            //   3d55555515           | cmp                 eax, 0x15555555
            //   0f846b010000         | je                  0x171
            //   8b4b08               | mov                 ecx, dword ptr [ebx + 8]
            //   8d7001               | lea                 esi, [eax + 1]
            //   2bcf                 | sub                 ecx, edi
            //   b8abaaaa2a           | mov                 eax, 0x2aaaaaab
            //   f7e9                 | imul                ecx

        $sequence_1 = { c645cc00 898570feffff 3bf0 7432 8bbd64feffff 8b4de4 03cf }
            // n = 7, score = 200
            //   c645cc00             | mov                 byte ptr [ebp - 0x34], 0
            //   898570feffff         | mov                 dword ptr [ebp - 0x190], eax
            //   3bf0                 | cmp                 esi, eax
            //   7432                 | je                  0x34
            //   8bbd64feffff         | mov                 edi, dword ptr [ebp - 0x19c]
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   03cf                 | add                 ecx, edi

        $sequence_2 = { 8d4de4 e8???????? 8a75d7 8b75e8 8b5dec 8b45c4 }
            // n = 6, score = 200
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   e8????????           |                     
            //   8a75d7               | mov                 dh, byte ptr [ebp - 0x29]
            //   8b75e8               | mov                 esi, dword ptr [ebp - 0x18]
            //   8b5dec               | mov                 ebx, dword ptr [ebp - 0x14]
            //   8b45c4               | mov                 eax, dword ptr [ebp - 0x3c]

        $sequence_3 = { 7e0f 803c0f22 0f84d6000000 41 3bc8 7cf1 33c0 }
            // n = 7, score = 200
            //   7e0f                 | jle                 0x11
            //   803c0f22             | cmp                 byte ptr [edi + ecx], 0x22
            //   0f84d6000000         | je                  0xdc
            //   41                   | inc                 ecx
            //   3bc8                 | cmp                 ecx, eax
            //   7cf1                 | jl                  0xfffffff3
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { c785bcfdffff00000000 c785c0fdffff0f000000 c685acfdffff00 83fa10 722f 8b8d64fdffff 42 }
            // n = 7, score = 200
            //   c785bcfdffff00000000     | mov    dword ptr [ebp - 0x244], 0
            //   c785c0fdffff0f000000     | mov    dword ptr [ebp - 0x240], 0xf
            //   c685acfdffff00       | mov                 byte ptr [ebp - 0x254], 0
            //   83fa10               | cmp                 edx, 0x10
            //   722f                 | jb                  0x31
            //   8b8d64fdffff         | mov                 ecx, dword ptr [ebp - 0x29c]
            //   42                   | inc                 edx

        $sequence_5 = { 83c404 85c0 0f844a010000 8d7823 83e7e0 8947fc eb13 }
            // n = 7, score = 200
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   0f844a010000         | je                  0x150
            //   8d7823               | lea                 edi, [eax + 0x23]
            //   83e7e0               | and                 edi, 0xffffffe0
            //   8947fc               | mov                 dword ptr [edi - 4], eax
            //   eb13                 | jmp                 0x15

        $sequence_6 = { c7805413440002000000 6a04 58 6bc000 8b0d???????? 894c05f8 6a04 }
            // n = 7, score = 200
            //   c7805413440002000000     | mov    dword ptr [eax + 0x441354], 2
            //   6a04                 | push                4
            //   58                   | pop                 eax
            //   6bc000               | imul                eax, eax, 0
            //   8b0d????????         |                     
            //   894c05f8             | mov                 dword ptr [ebp + eax - 8], ecx
            //   6a04                 | push                4

        $sequence_7 = { c745c800000000 c645fc02 3b4dec 741a 33d2 33f6 8911 }
            // n = 7, score = 200
            //   c745c800000000       | mov                 dword ptr [ebp - 0x38], 0
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   3b4dec               | cmp                 ecx, dword ptr [ebp - 0x14]
            //   741a                 | je                  0x1c
            //   33d2                 | xor                 edx, edx
            //   33f6                 | xor                 esi, esi
            //   8911                 | mov                 dword ptr [ecx], edx

        $sequence_8 = { 8875d7 3bf9 7408 8817 47 897de8 eb13 }
            // n = 7, score = 200
            //   8875d7               | mov                 byte ptr [ebp - 0x29], dh
            //   3bf9                 | cmp                 edi, ecx
            //   7408                 | je                  0xa
            //   8817                 | mov                 byte ptr [edi], dl
            //   47                   | inc                 edi
            //   897de8               | mov                 dword ptr [ebp - 0x18], edi
            //   eb13                 | jmp                 0x15

        $sequence_9 = { b8abaaaa2a 2bcf 895df0 f7e9 8b4b04 c1fa03 2bcf }
            // n = 7, score = 200
            //   b8abaaaa2a           | mov                 eax, 0x2aaaaaab
            //   2bcf                 | sub                 ecx, edi
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   f7e9                 | imul                ecx
            //   8b4b04               | mov                 ecx, dword ptr [ebx + 4]
            //   c1fa03               | sar                 edx, 3
            //   2bcf                 | sub                 ecx, edi

    condition:
        7 of them and filesize < 581632
}