rule win_juicy_potato_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.juicy_potato."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.juicy_potato"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8521ffffff 44882b eb7b 488b9540070000 4c8d05d7b20200 }
            // n = 5, score = 100
            //   0f8521ffffff         | lea                 eax, [0x193c9]
            //   44882b               | test                al, al
            //   eb7b                 | je                  0xdc
            //   488b9540070000       | dec                 eax
            //   4c8d05d7b20200       | lea                 ecx, [0x95f]

        $sequence_1 = { e8???????? 488d1548380300 488d4c2420 e8???????? cc 488d4c2420 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d1548380300       | dec                 eax
            //   488d4c2420           | lea                 ecx, [edi + 8]
            //   e8????????           |                     
            //   cc                   | nop                 
            //   488d4c2420           | dec                 eax
            //   e8????????           |                     

        $sequence_2 = { 0fb7d0 488d8de0000000 81ca00000780 85c0 0f4ed0 e8???????? 488d15a8350200 }
            // n = 7, score = 100
            //   0fb7d0               | lea                 ecx, [0x4225e]
            //   488d8de0000000       | mov                 dword ptr [ebp - 0x10], esi
            //   81ca00000780         | test                eax, eax
            //   85c0                 | jne                 0x3c2
            //   0f4ed0               | dec                 eax
            //   e8????????           |                     
            //   488d15a8350200       | lea                 ecx, [0x422c8]

        $sequence_3 = { 488d054ab1ffff 4889442438 488d4c2428 e8???????? }
            // n = 4, score = 100
            //   488d054ab1ffff       | mov                 dword ptr [eax + 0x28], ecx
            //   4889442438           | dec                 eax
            //   488d4c2428           | mov                 ecx, eax
            //   e8????????           |                     

        $sequence_4 = { e8???????? eb98 488d4c2420 e8???????? 488d15fee90200 488d4c2420 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   eb98                 | dec                 eax
            //   488d4c2420           | lea                 ecx, [0x4d96f]
            //   e8????????           |                     
            //   488d15fee90200       | jne                 0x115
            //   488d4c2420           | dec                 eax

        $sequence_5 = { 4889442430 8b442478 89442428 488b442470 4c8b11 4889442420 }
            // n = 6, score = 100
            //   4889442430           | dec                 eax
            //   8b442478             | mov                 dword ptr [esp + 0x8b8], ebx
            //   89442428             | mov                 ecx, 0x10
            //   488b442470           | dec                 eax
            //   4c8b11               | mov                 dword ptr [ebx], eax
            //   4889442420           | dec                 eax

        $sequence_6 = { 488901 488d05660b0100 48894110 f6c201 740a ba90000000 e8???????? }
            // n = 7, score = 100
            //   488901               | mov                 ebx, dword ptr [esp + 0x60]
            //   488d05660b0100       | dec                 eax
            //   48894110             | add                 esp, 0x30
            //   f6c201               | int3                
            //   740a                 | je                  0xd78
            //   ba90000000           | jne                 0xd87
            //   e8????????           |                     

        $sequence_7 = { 4885c0 7509 488d056f200400 eb04 4883c024 8938 e8???????? }
            // n = 7, score = 100
            //   4885c0               | nop                 dword ptr [eax + eax]
            //   7509                 | dec                 eax
            //   488d056f200400       | mov                 eax, dword ptr [edi + 0x10]
            //   eb04                 | mov                 edx, dword ptr [eax + 8]
            //   4883c024             | dec                 esp
            //   8938                 | lea                 ecx, [esp + 0x48]
            //   e8????????           |                     

        $sequence_8 = { 4883ec20 488bd9 488bc2 488d0d9dc10000 48890b }
            // n = 5, score = 100
            //   4883ec20             | mov                 eax, ebx
            //   488bd9               | dec                 eax
            //   488bc2               | lea                 eax, [0x1b0e9]
            //   488d0d9dc10000       | dec                 eax
            //   48890b               | mov                 dword ptr [ebx], eax

        $sequence_9 = { 44016f6c 48875308 4c396b08 7521 8364242800 488d0560acfeff 4889442430 }
            // n = 7, score = 100
            //   44016f6c             | mov                 ebx, eax
            //   48875308             | dec                 eax
            //   4c396b08             | mov                 dword ptr [esp + 0x50], eax
            //   7521                 | xor                 edx, edx
            //   8364242800           | inc                 esp
            //   488d0560acfeff       | lea                 eax, [edx + 0x60]
            //   4889442430           | mov                 ecx, 0x64

    condition:
        7 of them and filesize < 736256
}