rule win_jupiter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.jupiter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jupiter"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c605????????01 66c705????????0101 c605????????01 c605????????01 }
            // n = 4, score = 400
            //   c605????????01       |                     
            //   66c705????????0101     |     
            //   c605????????01       |                     
            //   c605????????01       |                     

        $sequence_1 = { 8a4147 884104 8a4146 884105 8b4144 c1f808 884106 }
            // n = 7, score = 400
            //   8a4147               | push                edx
            //   884104               | dec                 eax
            //   8a4146               | lea                 ecx, [0xefd3]
            //   884105               | mov                 dword ptr [esp + 0x20], 0x11c
            //   8b4144               | dec                 eax
            //   c1f808               | test                eax, eax
            //   884106               | je                  0x157b

        $sequence_2 = { 884104 8a4146 884105 8b4144 c1f808 884106 8a4144 }
            // n = 7, score = 400
            //   884104               | dec                 eax
            //   8a4146               | mov                 ecx, edi
            //   884105               | dec                 eax
            //   8b4144               | mov                 ecx, ebx
            //   c1f808               | dec                 eax
            //   884106               | mov                 ecx, dword ptr [edi]
            //   8a4144               | dec                 eax

        $sequence_3 = { 8a4146 884105 8b4144 c1f808 884106 }
            // n = 5, score = 400
            //   8a4146               | dec                 eax
            //   884105               | lea                 edx, [esp + 0x40]
            //   8b4144               | dec                 eax
            //   c1f808               | mov                 edi, ecx
            //   884106               | dec                 eax

        $sequence_4 = { c605????????01 c605????????01 66c705????????0101 c605????????01 }
            // n = 4, score = 400
            //   c605????????01       |                     
            //   c605????????01       |                     
            //   66c705????????0101     |     
            //   c605????????01       |                     

        $sequence_5 = { 8a4147 884104 8a4146 884105 }
            // n = 4, score = 400
            //   8a4147               | mov                 esi, dword ptr [esp + 0x10]
            //   884104               | push                edi
            //   8a4146               | mov                 edi, dword ptr [esi + 0x3508]
            //   884105               | push                esi

        $sequence_6 = { c605????????01 66c705????????0101 c605????????01 c605????????01 66c705????????0101 c605????????01 }
            // n = 6, score = 400
            //   c605????????01       |                     
            //   66c705????????0101     |     
            //   c605????????01       |                     
            //   c605????????01       |                     
            //   66c705????????0101     |     
            //   c605????????01       |                     

        $sequence_7 = { 884104 8a4146 884105 8b4144 }
            // n = 4, score = 400
            //   884104               | mov                 dword ptr [esp + 0x90], eax
            //   8a4146               | dec                 eax
            //   884105               | mov                 eax, dword ptr [esp + 0x140]
            //   8b4144               | dec                 ebp

        $sequence_8 = { 52 52 6802000000 6803000000 }
            // n = 4, score = 400
            //   52                   | mov                 dword ptr [eax + 0x18], eax
            //   52                   | mov                 dword ptr [eax + 8], ecx
            //   6802000000           | dec                 eax
            //   6803000000           | mov                 eax, ebp

        $sequence_9 = { 8a4146 884105 8b4144 c1f808 }
            // n = 4, score = 400
            //   8a4146               | mov                 esi, dword ptr [esp + 0x10]
            //   884105               | push                edi
            //   8b4144               | jne                 0x5c0
            //   c1f808               | push                esi

    condition:
        7 of them and filesize < 224112
}