rule win_kagent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kagent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kagent"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83ec0c 56 57 8bf8 8b7744 8b4f18 c745f800000000 }
            // n = 7, score = 400
            //   83ec0c               | sub                 esp, 0xc
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   8b7744               | mov                 esi, dword ptr [edi + 0x44]
            //   8b4f18               | mov                 ecx, dword ptr [edi + 0x18]
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0

        $sequence_1 = { 85c0 7e2b 3bf0 7d51 85f6 784d 8b450c }
            // n = 7, score = 400
            //   85c0                 | test                eax, eax
            //   7e2b                 | jle                 0x2d
            //   3bf0                 | cmp                 esi, eax
            //   7d51                 | jge                 0x53
            //   85f6                 | test                esi, esi
            //   784d                 | js                  0x4f
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_2 = { ff15???????? 57 ffd6 68???????? e8???????? 83c404 53 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   53                   | push                ebx

        $sequence_3 = { 50 8d45f4 64a300000000 8a450c 8b5d10 8955ac 8b5518 }
            // n = 7, score = 400
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8a450c               | mov                 al, byte ptr [ebp + 0xc]
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   8955ac               | mov                 dword ptr [ebp - 0x54], edx
            //   8b5518               | mov                 edx, dword ptr [ebp + 0x18]

        $sequence_4 = { 56 8d75ec e8???????? 8b4804 8b4704 bb01000000 e8???????? }
            // n = 7, score = 400
            //   56                   | push                esi
            //   8d75ec               | lea                 esi, [ebp - 0x14]
            //   e8????????           |                     
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   bb01000000           | mov                 ebx, 1
            //   e8????????           |                     

        $sequence_5 = { ffd6 668b542410 663b542420 74ed ff15???????? 33d2 b9e8030000 }
            // n = 7, score = 400
            //   ffd6                 | call                esi
            //   668b542410           | mov                 dx, word ptr [esp + 0x10]
            //   663b542420           | cmp                 dx, word ptr [esp + 0x20]
            //   74ed                 | je                  0xffffffef
            //   ff15????????         |                     
            //   33d2                 | xor                 edx, edx
            //   b9e8030000           | mov                 ecx, 0x3e8

        $sequence_6 = { 8b4004 33f6 83c40c 897220 897224 8b5580 52 }
            // n = 7, score = 400
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   33f6                 | xor                 esi, esi
            //   83c40c               | add                 esp, 0xc
            //   897220               | mov                 dword ptr [edx + 0x20], esi
            //   897224               | mov                 dword ptr [edx + 0x24], esi
            //   8b5580               | mov                 edx, dword ptr [ebp - 0x80]
            //   52                   | push                edx

        $sequence_7 = { 56 8bf0 57 3b7508 745a 8d542410 33c9 }
            // n = 7, score = 400
            //   56                   | push                esi
            //   8bf0                 | mov                 esi, eax
            //   57                   | push                edi
            //   3b7508               | cmp                 esi, dword ptr [ebp + 8]
            //   745a                 | je                  0x5c
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   33c9                 | xor                 ecx, ecx

        $sequence_8 = { e8???????? c7459c09000000 895de8 8d8d6cffffff 51 57 c645fc05 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   c7459c09000000       | mov                 dword ptr [ebp - 0x64], 9
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx
            //   8d8d6cffffff         | lea                 ecx, [ebp - 0x94]
            //   51                   | push                ecx
            //   57                   | push                edi
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5

        $sequence_9 = { 50 68???????? 68???????? e8???????? 83c40c eb24 }
            // n = 6, score = 400
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   eb24                 | jmp                 0x26

    condition:
        7 of them and filesize < 4972544
}