rule win_kaolin_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kaolin_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kaolin_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 44897c2428 44897c2420 4533c9 4533c0 488bd0 33c9 }
            // n = 6, score = 100
            //   44897c2428           | inc                 ebp
            //   44897c2420           | xor                 edx, edx
            //   4533c9               | nop                 word ptr [eax + eax]
            //   4533c0               | inc                 ecx
            //   488bd0               | cmp                 edx, 8
            //   33c9                 | jl                  0xc35

        $sequence_1 = { 66c704083f00 eb1d 48c744242001000000 4c8d0df8af0200 ba01000000 498bcc e8???????? }
            // n = 7, score = 100
            //   66c704083f00         | mov                 eax, ebp
            //   eb1d                 | dec                 ecx
            //   48c744242001000000     | arpl    cx, cx
            //   4c8d0df8af0200       | dec                 eax
            //   ba01000000           | cmp                 ecx, ebx
            //   498bcc               | cmp                 word ptr [ecx], ax
            //   e8????????           |                     

        $sequence_2 = { 488bd7 488d4d08 e8???????? 488b4d18 488b5520 488bc2 482bc1 }
            // n = 7, score = 100
            //   488bd7               | ja                  0x4b6
            //   488d4d08             | dec                 esp
            //   e8????????           |                     
            //   488b4d18             | mov                 dword ptr [ebp - 0x70], esp
            //   488b5520             | dec                 eax
            //   488bc2               | mov                 ecx, dword ptr [ecx - 8]
            //   482bc1               | dec                 eax

        $sequence_3 = { 488b8a30000000 e9???????? 488b8a60000000 e9???????? 4055 4883ec20 488bea }
            // n = 7, score = 100
            //   488b8a30000000       | jae                 0x1f50
            //   e9????????           |                     
            //   488b8a60000000       | inc                 ecx
            //   e9????????           |                     
            //   4055                 | movups              xmm0, xmmword ptr [esi]
            //   4883ec20             | dec                 eax
            //   488bea               | mov                 dword ptr [ebp - 0x11], esi

        $sequence_4 = { 48833d????????10 480f4305???????? 448828 418bdd 48391d???????? }
            // n = 5, score = 100
            //   48833d????????10     |                     
            //   480f4305????????     |                     
            //   448828               | lea                 ecx, [eax + eax*8]
            //   418bdd               | dec                 eax
            //   48391d????????       |                     

        $sequence_5 = { 4c8d0dab4c0200 ba03000000 488bcf e8???????? }
            // n = 4, score = 100
            //   4c8d0dab4c0200       | dec                 eax
            //   ba03000000           | mov                 dword ptr [ebp - 0x40], 0
            //   488bcf               | dec                 eax
            //   e8????????           |                     

        $sequence_6 = { 4885c0 750a b9c8000000 e9???????? 4c8b6008 488b00 83b88c00000000 }
            // n = 7, score = 100
            //   4885c0               | mov                 dword ptr [esp + 0x30], ecx
            //   750a                 | mov                 byte ptr [esp + 0x20], cl
            //   b9c8000000           | dec                 eax
            //   e9????????           |                     
            //   4c8b6008             | add                 eax, ebx
            //   488b00               | dec                 eax
            //   83b88c00000000       | mov                 ecx, dword ptr [ebp + 0x30]

        $sequence_7 = { ba04010000 488d8db0000000 e8???????? 418bcf 48890d???????? 488d3d5eae0300 488d1517b00300 }
            // n = 7, score = 100
            //   ba04010000           | test                ecx, ecx
            //   488d8db0000000       | jle                 0x1c3d
            //   e8????????           |                     
            //   418bcf               | dec                 eax
            //   48890d????????       |                     
            //   488d3d5eae0300       | lea                 edx, [ebp + 1]
            //   488d1517b00300       | nop                 dword ptr [eax + eax]

        $sequence_8 = { 4883fa10 480f431d???????? 4803d9 4d8bc6 498bd5 488bcb e8???????? }
            // n = 7, score = 100
            //   4883fa10             | mov                 byte ptr [ebp + 0x30], bh
            //   480f431d????????     |                     
            //   4803d9               | dec                 esp
            //   4d8bc6               | mov                 dword ptr [ebp + 0x60], edi
            //   498bd5               | dec                 eax
            //   488bcb               | mov                 dword ptr [ebp + 0x68], 0xf
            //   e8????????           |                     

        $sequence_9 = { 482bc1 4883f801 721d 488d4101 488945d0 488d45c0 4883fa10 }
            // n = 7, score = 100
            //   482bc1               | mov                 ecx, dword ptr [esp + 0x128]
            //   4883f801             | jb                  0x183d
            //   721d                 | inc                 ecx
            //   488d4101             | call                ebp
            //   488945d0             | dec                 eax
            //   488d45c0             | mov                 edx, ebx
            //   4883fa10             | dec                 eax

    condition:
        7 of them and filesize < 581632
}