rule win_karagany_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.karagany."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.karagany"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945d0 8945d8 8945e0 8945e8 8945ec 8945f4 }
            // n = 6, score = 400
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_1 = { 8bf8 6a03 57 ffd6 }
            // n = 4, score = 400
            //   8bf8                 | mov                 edi, eax
            //   6a03                 | push                3
            //   57                   | push                edi
            //   ffd6                 | call                esi

        $sequence_2 = { 57 8bf8 6a03 57 }
            // n = 4, score = 400
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   6a03                 | push                3
            //   57                   | push                edi

        $sequence_3 = { 8945d8 8945e0 8945e8 8945ec 8945f4 }
            // n = 5, score = 400
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_4 = { 6a40 6800300000 6800000300 6a00 }
            // n = 4, score = 400
            //   6a40                 | push                0x40
            //   6800300000           | push                0x3000
            //   6800000300           | push                0x30000
            //   6a00                 | push                0

        $sequence_5 = { 8b4508 0526f8ffff 69c06c010000 034510 }
            // n = 4, score = 400
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0526f8ffff           | add                 eax, 0xfffff826
            //   69c06c010000         | imul                eax, eax, 0x16c
            //   034510               | add                 eax, dword ptr [ebp + 0x10]

        $sequence_6 = { 8bec 81ec60060000 53 56 57 33c0 }
            // n = 6, score = 400
            //   8bec                 | mov                 ebp, esp
            //   81ec60060000         | sub                 esp, 0x660
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33c0                 | xor                 eax, eax

        $sequence_7 = { ff15???????? 6a00 53 68???????? }
            // n = 4, score = 400
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   53                   | push                ebx
            //   68????????           |                     

        $sequence_8 = { 68???????? 8d85a4fdffff 50 ffd6 68???????? }
            // n = 5, score = 400
            //   68????????           |                     
            //   8d85a4fdffff         | lea                 eax, [ebp - 0x25c]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   68????????           |                     

        $sequence_9 = { 8bd8 2bc7 40 50 57 }
            // n = 5, score = 400
            //   8bd8                 | mov                 ebx, eax
            //   2bc7                 | sub                 eax, edi
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   57                   | push                edi

    condition:
        7 of them and filesize < 180224
}