rule win_keyboy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.keyboy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.keyboy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 ff75d8 6a00 ff75c0 }
            // n = 4, score = 600
            //   51                   | push                ecx
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   6a00                 | push                0
            //   ff75c0               | push                dword ptr [ebp - 0x40]

        $sequence_1 = { 6a00 8945f2 8d45f8 50 6a0e }
            // n = 5, score = 600
            //   6a00                 | push                0
            //   8945f2               | mov                 dword ptr [ebp - 0xe], eax
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   6a0e                 | push                0xe

        $sequence_2 = { 5d c3 3b0d???????? f27502 f2c3 f2e953030000 }
            // n = 6, score = 500
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   3b0d????????         |                     
            //   f27502               | bnd jne             5
            //   f2c3                 | bnd ret             
            //   f2e953030000         | bnd jmp             0x359

        $sequence_3 = { c705????????dbd99823 c705????????d468bcb5 c705????????2086e659 c705????????eec45abf c705????????bbee2bd1 c705????????3e20f129 }
            // n = 6, score = 500
            //   c705????????dbd99823     |     
            //   c705????????d468bcb5     |     
            //   c705????????2086e659     |     
            //   c705????????eec45abf     |     
            //   c705????????bbee2bd1     |     
            //   c705????????3e20f129     |     

        $sequence_4 = { c705????????0caa6c89 c705????????a856701f c705????????597e743c c705????????0a9769e0 c705????????c4b85363 }
            // n = 5, score = 500
            //   c705????????0caa6c89     |     
            //   c705????????a856701f     |     
            //   c705????????597e743c     |     
            //   c705????????0a9769e0     |     
            //   c705????????c4b85363     |     

        $sequence_5 = { c705????????0a9769e0 c705????????c4b85363 c705????????3abf261f c705????????890e9944 c705????????dbd99823 c705????????d468bcb5 c705????????2086e659 }
            // n = 7, score = 500
            //   c705????????0a9769e0     |     
            //   c705????????c4b85363     |     
            //   c705????????3abf261f     |     
            //   c705????????890e9944     |     
            //   c705????????dbd99823     |     
            //   c705????????d468bcb5     |     
            //   c705????????2086e659     |     

        $sequence_6 = { 57 68cc020000 8d852cfdffff 8bf2 6a00 50 89b528fdffff }
            // n = 7, score = 400
            //   57                   | push                edi
            //   68cc020000           | push                0x2cc
            //   8d852cfdffff         | lea                 eax, [ebp - 0x2d4]
            //   8bf2                 | mov                 esi, edx
            //   6a00                 | push                0
            //   50                   | push                eax
            //   89b528fdffff         | mov                 dword ptr [ebp - 0x2d8], esi

        $sequence_7 = { 24a0 3ca0 7518 b800080000 }
            // n = 4, score = 400
            //   24a0                 | and                 al, 0xa0
            //   3ca0                 | cmp                 al, 0xa0
            //   7518                 | jne                 0x1a
            //   b800080000           | mov                 eax, 0x800

        $sequence_8 = { 2408 f6d8 1ac0 24dd 88474e }
            // n = 5, score = 400
            //   2408                 | and                 al, 8
            //   f6d8                 | neg                 al
            //   1ac0                 | sbb                 al, al
            //   24dd                 | and                 al, 0xdd
            //   88474e               | mov                 byte ptr [edi + 0x4e], al

        $sequence_9 = { 7207 b901000000 eb0f 3cfe 7509 }
            // n = 5, score = 400
            //   7207                 | jb                  9
            //   b901000000           | mov                 ecx, 1
            //   eb0f                 | jmp                 0x11
            //   3cfe                 | cmp                 al, 0xfe
            //   7509                 | jne                 0xb

        $sequence_10 = { 6683f809 740a 6683f806 7404 32c9 eb02 }
            // n = 6, score = 400
            //   6683f809             | cmp                 ax, 9
            //   740a                 | je                  0xc
            //   6683f806             | cmp                 ax, 6
            //   7404                 | je                  6
            //   32c9                 | xor                 cl, cl
            //   eb02                 | jmp                 4

        $sequence_11 = { 7905 49 83c9f8 41 8a043e 0fbe4c8de0 3401 }
            // n = 7, score = 400
            //   7905                 | jns                 7
            //   49                   | dec                 ecx
            //   83c9f8               | or                  ecx, 0xfffffff8
            //   41                   | inc                 ecx
            //   8a043e               | mov                 al, byte ptr [esi + edi]
            //   0fbe4c8de0           | movsx               ecx, byte ptr [ebp + ecx*4 - 0x20]
            //   3401                 | xor                 al, 1

        $sequence_12 = { 0fbe4c8de0 3401 0fbec0 0fafc8 80f185 880c3e }
            // n = 6, score = 400
            //   0fbe4c8de0           | movsx               ecx, byte ptr [ebp + ecx*4 - 0x20]
            //   3401                 | xor                 al, 1
            //   0fbec0               | movsx               eax, al
            //   0fafc8               | imul                ecx, eax
            //   80f185               | xor                 cl, 0x85
            //   880c3e               | mov                 byte ptr [esi + edi], cl

        $sequence_13 = { e8???????? 85c0 755e 83ff20 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   755e                 | jne                 0x60
            //   83ff20               | cmp                 edi, 0x20

        $sequence_14 = { f7d9 85db 0f44c2 23c8 }
            // n = 4, score = 400
            //   f7d9                 | neg                 ecx
            //   85db                 | test                ebx, ebx
            //   0f44c2               | cmove               eax, edx
            //   23c8                 | and                 ecx, eax

        $sequence_15 = { c705????????1671e665 c705????????f3106cb3 c705????????526c1ed0 c705????????5d05606c }
            // n = 4, score = 400
            //   c705????????1671e665     |     
            //   c705????????f3106cb3     |     
            //   c705????????526c1ed0     |     
            //   c705????????5d05606c     |     

        $sequence_16 = { ffd0 e9???????? bbfeffffff eb05 }
            // n = 4, score = 400
            //   ffd0                 | call                eax
            //   e9????????           |                     
            //   bbfeffffff           | mov                 ebx, 0xfffffffe
            //   eb05                 | jmp                 7

        $sequence_17 = { 84c0 75f0 8d55ec c745ec5c417070 c745f06c655c55 }
            // n = 5, score = 400
            //   84c0                 | test                al, al
            //   75f0                 | jne                 0xfffffff2
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   c745ec5c417070       | mov                 dword ptr [ebp - 0x14], 0x7070415c
            //   c745f06c655c55       | mov                 dword ptr [ebp - 0x10], 0x555c656c

        $sequence_18 = { e8???????? 8b75c0 8bce 8b15???????? a3???????? e8???????? 8b15???????? }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8b75c0               | mov                 esi, dword ptr [ebp - 0x40]
            //   8bce                 | mov                 ecx, esi
            //   8b15????????         |                     
            //   a3????????           |                     
            //   e8????????           |                     
            //   8b15????????         |                     

        $sequence_19 = { 8d46d6 99 83e23f 03c2 }
            // n = 4, score = 400
            //   8d46d6               | lea                 eax, [esi - 0x2a]
            //   99                   | cdq                 
            //   83e23f               | and                 edx, 0x3f
            //   03c2                 | add                 eax, edx

        $sequence_20 = { ff15???????? 8bf8 c745f447646933 8d45f4 66c745f83200 50 }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   c745f447646933       | mov                 dword ptr [ebp - 0xc], 0x33696447
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   66c745f83200         | mov                 word ptr [ebp - 8], 0x32
            //   50                   | push                eax

        $sequence_21 = { c745f06c655c55 8bf2 c745f470646174 66c745f86500 8a02 }
            // n = 5, score = 400
            //   c745f06c655c55       | mov                 dword ptr [ebp - 0x10], 0x555c656c
            //   8bf2                 | mov                 esi, edx
            //   c745f470646174       | mov                 dword ptr [ebp - 0xc], 0x74616470
            //   66c745f86500         | mov                 word ptr [ebp - 8], 0x65
            //   8a02                 | mov                 al, byte ptr [edx]

    condition:
        7 of them and filesize < 2170880
}