rule win_keyhole_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.keyhole."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.keyhole"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d442404 0f11442404 50 0f11442418 c744240830000000 c744241090f36800 c744241c00000000 }
            // n = 7, score = 100
            //   8d442404             | lea                 eax, [esp + 4]
            //   0f11442404           | movups              xmmword ptr [esp + 4], xmm0
            //   50                   | push                eax
            //   0f11442418           | movups              xmmword ptr [esp + 0x18], xmm0
            //   c744240830000000     | mov                 dword ptr [esp + 8], 0x30
            //   c744241090f36800     | mov                 dword ptr [esp + 0x10], 0x68f390
            //   c744241c00000000     | mov                 dword ptr [esp + 0x1c], 0

        $sequence_1 = { 2bee 90 8a01 8d4901 884429ff 83ef01 75f2 }
            // n = 7, score = 100
            //   2bee                 | sub                 ebp, esi
            //   90                   | nop                 
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   8d4901               | lea                 ecx, [ecx + 1]
            //   884429ff             | mov                 byte ptr [ecx + ebp - 1], al
            //   83ef01               | sub                 edi, 1
            //   75f2                 | jne                 0xfffffff4

        $sequence_2 = { 6a00 ff15???????? 8bd8 85ff 7515 8b0d???????? 81c15d010000 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   85ff                 | test                edi, edi
            //   7515                 | jne                 0x17
            //   8b0d????????         |                     
            //   81c15d010000         | add                 ecx, 0x15d

        $sequence_3 = { 47 83c414 83c614 3bf8 72da a1???????? 33ff }
            // n = 7, score = 100
            //   47                   | inc                 edi
            //   83c414               | add                 esp, 0x14
            //   83c614               | add                 esi, 0x14
            //   3bf8                 | cmp                 edi, eax
            //   72da                 | jb                  0xffffffdc
            //   a1????????           |                     
            //   33ff                 | xor                 edi, edi

        $sequence_4 = { 83ec08 53 8b5c2418 8bc3 d1e8 56 8d3440 }
            // n = 7, score = 100
            //   83ec08               | sub                 esp, 8
            //   53                   | push                ebx
            //   8b5c2418             | mov                 ebx, dword ptr [esp + 0x18]
            //   8bc3                 | mov                 eax, ebx
            //   d1e8                 | shr                 eax, 1
            //   56                   | push                esi
            //   8d3440               | lea                 esi, [eax + eax*2]

        $sequence_5 = { c3 a900080000 7404 33c0 eb11 56 53 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   a900080000           | test                eax, 0x800
            //   7404                 | je                  6
            //   33c0                 | xor                 eax, eax
            //   eb11                 | jmp                 0x13
            //   56                   | push                esi
            //   53                   | push                ebx

        $sequence_6 = { 7507 b9f5060000 eb1a 83f920 7205 83f97e 761e }
            // n = 7, score = 100
            //   7507                 | jne                 9
            //   b9f5060000           | mov                 ecx, 0x6f5
            //   eb1a                 | jmp                 0x1c
            //   83f920               | cmp                 ecx, 0x20
            //   7205                 | jb                  7
            //   83f97e               | cmp                 ecx, 0x7e
            //   761e                 | jbe                 0x20

        $sequence_7 = { 85c0 741f 53 e8???????? 83c404 85c0 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   741f                 | je                  0x21
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax

        $sequence_8 = { 3bf7 725d 8b7c2420 8bc2 25ff030000 0fbf844560010000 89442410 }
            // n = 7, score = 100
            //   3bf7                 | cmp                 esi, edi
            //   725d                 | jb                  0x5f
            //   8b7c2420             | mov                 edi, dword ptr [esp + 0x20]
            //   8bc2                 | mov                 eax, edx
            //   25ff030000           | and                 eax, 0x3ff
            //   0fbf844560010000     | movsx               eax, word ptr [ebp + eax*2 + 0x160]
            //   89442410             | mov                 dword ptr [esp + 0x10], eax

        $sequence_9 = { 8d442420 50 55 6a00 ff15???????? 8b442428 8b542420 }
            // n = 7, score = 100
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   50                   | push                eax
            //   55                   | push                ebp
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   8b542420             | mov                 edx, dword ptr [esp + 0x20]

    condition:
        7 of them and filesize < 303104
}