rule win_keylogger_apt3_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.keylogger_apt3."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.keylogger_apt3"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ffd7 8b4e08 6a08 51 ffd7 }
            // n = 6, score = 300
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   6a08                 | push                8
            //   51                   | push                ecx
            //   ffd7                 | call                edi

        $sequence_1 = { 8b9c2430040000 55 8bac2430040000 56 57 8bbc2434040000 6800010000 }
            // n = 7, score = 300
            //   8b9c2430040000       | mov                 ebx, dword ptr [esp + 0x430]
            //   55                   | push                ebp
            //   8bac2430040000       | mov                 ebp, dword ptr [esp + 0x430]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bbc2434040000       | mov                 edi, dword ptr [esp + 0x434]
            //   6800010000           | push                0x100

        $sequence_2 = { 52 ffd7 8b0d???????? 8d442424 50 51 }
            // n = 6, score = 300
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   8b0d????????         |                     
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_3 = { 8d45f0 50 e8???????? cc e8???????? 8b4004 c3 }
            // n = 7, score = 300
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   e8????????           |                     
            //   cc                   | int3                
            //   e8????????           |                     
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   c3                   | ret                 

        $sequence_4 = { e8???????? 55 e8???????? 68???????? e8???????? 8b8c2440020000 83c40c }
            // n = 7, score = 300
            //   e8????????           |                     
            //   55                   | push                ebp
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   8b8c2440020000       | mov                 ecx, dword ptr [esp + 0x240]
            //   83c40c               | add                 esp, 0xc

        $sequence_5 = { 52 ffd7 a1???????? 896844 8b9eac010000 85db 742e }
            // n = 7, score = 300
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   a1????????           |                     
            //   896844               | mov                 dword ptr [eax + 0x44], ebp
            //   8b9eac010000         | mov                 ebx, dword ptr [esi + 0x1ac]
            //   85db                 | test                ebx, ebx
            //   742e                 | je                  0x30

        $sequence_6 = { 52 e8???????? 8d862c020000 50 8d4c242c 68???????? 51 }
            // n = 7, score = 300
            //   52                   | push                edx
            //   e8????????           |                     
            //   8d862c020000         | lea                 eax, [esi + 0x22c]
            //   50                   | push                eax
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   68????????           |                     
            //   51                   | push                ecx

        $sequence_7 = { 8d7c00ff 3bc7 89442418 0f8dc6000000 8b542414 8bd8 69db14010000 }
            // n = 7, score = 300
            //   8d7c00ff             | lea                 edi, [eax + eax - 1]
            //   3bc7                 | cmp                 eax, edi
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   0f8dc6000000         | jge                 0xcc
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   8bd8                 | mov                 ebx, eax
            //   69db14010000         | imul                ebx, ebx, 0x114

        $sequence_8 = { 68???????? 52 ffd7 8b0d???????? 8d442438 50 }
            // n = 6, score = 300
            //   68????????           |                     
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   8b0d????????         |                     
            //   8d442438             | lea                 eax, [esp + 0x38]
            //   50                   | push                eax

        $sequence_9 = { e8???????? 83c404 8b442414 6a00 6a00 6a10 8d54244c }
            // n = 7, score = 300
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a10                 | push                0x10
            //   8d54244c             | lea                 edx, [esp + 0x4c]

    condition:
        7 of them and filesize < 761856
}