rule win_khrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.khrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.khrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7415 ff35???????? e8???????? c705????????00000000 833d????????ff 7415 ff35???????? }
            // n = 7, score = 100
            //   7415                 | je                  0x17
            //   ff35????????         |                     
            //   e8????????           |                     
            //   c705????????00000000     |     
            //   833d????????ff       |                     
            //   7415                 | je                  0x17
            //   ff35????????         |                     

        $sequence_1 = { 0fb64306 a3???????? 8d7307 56 68???????? e8???????? 6a00 }
            // n = 7, score = 100
            //   0fb64306             | movzx               eax, byte ptr [ebx + 6]
            //   a3????????           |                     
            //   8d7307               | lea                 esi, [ebx + 7]
            //   56                   | push                esi
            //   68????????           |                     
            //   e8????????           |                     
            //   6a00                 | push                0

        $sequence_2 = { e8???????? eb0f 807b06ff 7509 8b4b07 51 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   eb0f                 | jmp                 0x11
            //   807b06ff             | cmp                 byte ptr [ebx + 6], 0xff
            //   7509                 | jne                 0xb
            //   8b4b07               | mov                 ecx, dword ptr [ebx + 7]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_3 = { 50 8d8500fcffff 50 6801000080 e8???????? }
            // n = 5, score = 100
            //   50                   | push                eax
            //   8d8500fcffff         | lea                 eax, [ebp - 0x400]
            //   50                   | push                eax
            //   6801000080           | push                0x80000001
            //   e8????????           |                     

        $sequence_4 = { c6430500 c6430600 894307 8d7b0b }
            // n = 4, score = 100
            //   c6430500             | mov                 byte ptr [ebx + 5], 0
            //   c6430600             | mov                 byte ptr [ebx + 6], 0
            //   894307               | mov                 dword ptr [ebx + 7], eax
            //   8d7b0b               | lea                 edi, [ebx + 0xb]

        $sequence_5 = { 66c746326500 66c746347700 66c746363a00 66c746380000 8db500feffff }
            // n = 5, score = 100
            //   66c746326500         | mov                 word ptr [esi + 0x32], 0x65
            //   66c746347700         | mov                 word ptr [esi + 0x34], 0x77
            //   66c746363a00         | mov                 word ptr [esi + 0x36], 0x3a
            //   66c746380000         | mov                 word ptr [esi + 0x38], 0
            //   8db500feffff         | lea                 esi, [ebp - 0x200]

        $sequence_6 = { 8d8500fcffff 50 e8???????? 6a00 51 8d8500fcffff 50 }
            // n = 7, score = 100
            //   8d8500fcffff         | lea                 eax, [ebp - 0x400]
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   8d8500fcffff         | lea                 eax, [ebp - 0x400]
            //   50                   | push                eax

        $sequence_7 = { e8???????? 0bc0 0f84da000000 d1e0 8985fcfbffff ffb5fcfbffff }
            // n = 6, score = 100
            //   e8????????           |                     
            //   0bc0                 | or                  eax, eax
            //   0f84da000000         | je                  0xe0
            //   d1e0                 | shl                 eax, 1
            //   8985fcfbffff         | mov                 dword ptr [ebp - 0x404], eax
            //   ffb5fcfbffff         | push                dword ptr [ebp - 0x404]

        $sequence_8 = { c9 c3 55 8bec 81c490fbffff }
            // n = 5, score = 100
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81c490fbffff         | add                 esp, 0xfffffb90

        $sequence_9 = { c9 c3 55 8bec 81c4f8fbffff 8d9d00fcffff }
            // n = 6, score = 100
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81c4f8fbffff         | add                 esp, 0xfffffbf8
            //   8d9d00fcffff         | lea                 ebx, [ebp - 0x400]

    condition:
        7 of them and filesize < 57344
}