rule win_killav_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.killav."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.killav"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c408 6a09 33c0 c745d800000000 68???????? 8d4dd8 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   6a09                 | push                9
            //   33c0                 | xor                 eax, eax
            //   c745d800000000       | mov                 dword ptr [ebp - 0x28], 0
            //   68????????           |                     
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]

        $sequence_1 = { 51 e8???????? 83c408 6a13 33c0 c745d800000000 68???????? }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   6a13                 | push                0x13
            //   33c0                 | xor                 eax, eax
            //   c745d800000000       | mov                 dword ptr [ebp - 0x28], 0
            //   68????????           |                     

        $sequence_2 = { 85c0 0f84b7910000 83f808 7d0f 6bc018 05???????? }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   0f84b7910000         | je                  0x91bd
            //   83f808               | cmp                 eax, 8
            //   7d0f                 | jge                 0x11
            //   6bc018               | imul                eax, eax, 0x18
            //   05????????           |                     

        $sequence_3 = { eb1a 8b4508 8bc8 83e03f c1f906 6bd038 8b0c8d70ba4300 }
            // n = 7, score = 200
            //   eb1a                 | jmp                 0x1c
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8bc8                 | mov                 ecx, eax
            //   83e03f               | and                 eax, 0x3f
            //   c1f906               | sar                 ecx, 6
            //   6bd038               | imul                edx, eax, 0x38
            //   8b0c8d70ba4300       | mov                 ecx, dword ptr [ecx*4 + 0x43ba70]

        $sequence_4 = { 8b0c8d70ba4300 804c112802 5b 2bf7 83e6fe 5f 8bc6 }
            // n = 7, score = 200
            //   8b0c8d70ba4300       | mov                 ecx, dword ptr [ecx*4 + 0x43ba70]
            //   804c112802           | or                  byte ptr [ecx + edx + 0x28], 2
            //   5b                   | pop                 ebx
            //   2bf7                 | sub                 esi, edi
            //   83e6fe               | and                 esi, 0xfffffffe
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi

        $sequence_5 = { 895db8 c745dc01000000 8b048570ba4300 8945d4 0f8533010000 8b55d4 8bc3 }
            // n = 7, score = 200
            //   895db8               | mov                 dword ptr [ebp - 0x48], ebx
            //   c745dc01000000       | mov                 dword ptr [ebp - 0x24], 1
            //   8b048570ba4300       | mov                 eax, dword ptr [eax*4 + 0x43ba70]
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   0f8533010000         | jne                 0x139
            //   8b55d4               | mov                 edx, dword ptr [ebp - 0x2c]
            //   8bc3                 | mov                 eax, ebx

        $sequence_6 = { 8b0b 8b4904 6a00 ff75dc ff75e8 }
            // n = 5, score = 200
            //   8b0b                 | mov                 ecx, dword ptr [ebx]
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]
            //   6a00                 | push                0
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   ff75e8               | push                dword ptr [ebp - 0x18]

        $sequence_7 = { 0fb74d08 33c0 663b88bcf34200 740d 83c002 83f814 }
            // n = 6, score = 200
            //   0fb74d08             | movzx               ecx, word ptr [ebp + 8]
            //   33c0                 | xor                 eax, eax
            //   663b88bcf34200       | cmp                 cx, word ptr [eax + 0x42f3bc]
            //   740d                 | je                  0xf
            //   83c002               | add                 eax, 2
            //   83f814               | cmp                 eax, 0x14

        $sequence_8 = { c645fc15 50 8d4dd0 e8???????? c645fc00 }
            // n = 5, score = 200
            //   c645fc15             | mov                 byte ptr [ebp - 4], 0x15
            //   50                   | push                eax
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   e8????????           |                     
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0

        $sequence_9 = { 741c 81f900000400 7542 0c80 88441628 8b04bd70ba4300 c644102901 }
            // n = 7, score = 200
            //   741c                 | je                  0x1e
            //   81f900000400         | cmp                 ecx, 0x40000
            //   7542                 | jne                 0x44
            //   0c80                 | or                  al, 0x80
            //   88441628             | mov                 byte ptr [esi + edx + 0x28], al
            //   8b04bd70ba4300       | mov                 eax, dword ptr [edi*4 + 0x43ba70]
            //   c644102901           | mov                 byte ptr [eax + edx + 0x29], 1

    condition:
        7 of them and filesize < 517120
}