rule win_killdisk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.killdisk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.killdisk"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8945e4 8b7508 c7465c904c4200 33ff }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   c7465c904c4200       | mov                 dword ptr [esi + 0x5c], 0x424c90
            //   33ff                 | xor                 edi, edi

        $sequence_1 = { 75f7 2bca 8d7c243c 8bf2 8bd1 }
            // n = 5, score = 100
            //   75f7                 | jne                 0xfffffff9
            //   2bca                 | sub                 ecx, edx
            //   8d7c243c             | lea                 edi, [esp + 0x3c]
            //   8bf2                 | mov                 esi, edx
            //   8bd1                 | mov                 edx, ecx

        $sequence_2 = { 881c24 e8???????? d2cd 80d213 66c1e204 8b5500 f8 }
            // n = 7, score = 100
            //   881c24               | mov                 byte ptr [esp], bl
            //   e8????????           |                     
            //   d2cd                 | ror                 ch, cl
            //   80d213               | adc                 dl, 0x13
            //   66c1e204             | shl                 dx, 4
            //   8b5500               | mov                 edx, dword ptr [ebp]
            //   f8                   | clc                 

        $sequence_3 = { eb09 8b442430 2bc1 c1f802 8d3c8500000000 57 }
            // n = 6, score = 100
            //   eb09                 | jmp                 0xb
            //   8b442430             | mov                 eax, dword ptr [esp + 0x30]
            //   2bc1                 | sub                 eax, ecx
            //   c1f802               | sar                 eax, 2
            //   8d3c8500000000       | lea                 edi, [eax*4]
            //   57                   | push                edi

        $sequence_4 = { c604243a 9c 8d642434 e9???????? }
            // n = 4, score = 100
            //   c604243a             | mov                 byte ptr [esp], 0x3a
            //   9c                   | pushfd              
            //   8d642434             | lea                 esp, [esp + 0x34]
            //   e9????????           |                     

        $sequence_5 = { 84c0 75c1 8d442404 50 }
            // n = 4, score = 100
            //   84c0                 | test                al, al
            //   75c1                 | jne                 0xffffffc3
            //   8d442404             | lea                 eax, [esp + 4]
            //   50                   | push                eax

        $sequence_6 = { e9???????? 66894500 66897c240c 882c24 }
            // n = 4, score = 100
            //   e9????????           |                     
            //   66894500             | mov                 word ptr [ebp], ax
            //   66897c240c           | mov                 word ptr [esp + 0xc], di
            //   882c24               | mov                 byte ptr [esp], ch

        $sequence_7 = { 0f8482000000 55 e8???????? 8b1d???????? }
            // n = 4, score = 100
            //   0f8482000000         | je                  0x88
            //   55                   | push                ebp
            //   e8????????           |                     
            //   8b1d????????         |                     

        $sequence_8 = { e8???????? 881438 e8???????? 9c c6442408cf 894508 e9???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   881438               | mov                 byte ptr [eax + edi], dl
            //   e8????????           |                     
            //   9c                   | pushfd              
            //   c6442408cf           | mov                 byte ptr [esp + 8], 0xcf
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   e9????????           |                     

        $sequence_9 = { 6800100000 51 8bf0 ff15???????? }
            // n = 4, score = 100
            //   6800100000           | push                0x1000
            //   51                   | push                ecx
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     

        $sequence_10 = { 46 66892c24 9c 8d64244c e9???????? 9c }
            // n = 6, score = 100
            //   46                   | inc                 esi
            //   66892c24             | mov                 word ptr [esp], bp
            //   9c                   | pushfd              
            //   8d64244c             | lea                 esp, [esp + 0x4c]
            //   e9????????           |                     
            //   9c                   | pushfd              

        $sequence_11 = { 88442408 50 8d642434 e9???????? }
            // n = 4, score = 100
            //   88442408             | mov                 byte ptr [esp + 8], al
            //   50                   | push                eax
            //   8d642434             | lea                 esp, [esp + 0x34]
            //   e9????????           |                     

        $sequence_12 = { 3b54242c 0f84d5000000 b83092c201 33ff e8???????? 85c0 }
            // n = 6, score = 100
            //   3b54242c             | cmp                 edx, dword ptr [esp + 0x2c]
            //   0f84d5000000         | je                  0xdb
            //   b83092c201           | mov                 eax, 0x1c29230
            //   33ff                 | xor                 edi, edi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_13 = { e9???????? 883424 ff742420 8f4500 9c }
            // n = 5, score = 100
            //   e9????????           |                     
            //   883424               | mov                 byte ptr [esp], dh
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   8f4500               | pop                 dword ptr [ebp]
            //   9c                   | pushfd              

        $sequence_14 = { f5 88742408 c70424ba7bbfa4 660fbae408 662dca11 e8???????? 881438 }
            // n = 7, score = 100
            //   f5                   | cmc                 
            //   88742408             | mov                 byte ptr [esp + 8], dh
            //   c70424ba7bbfa4       | mov                 dword ptr [esp], 0xa4bf7bba
            //   660fbae408           | bt                  sp, 8
            //   662dca11             | sub                 ax, 0x11ca
            //   e8????????           |                     
            //   881438               | mov                 byte ptr [eax + edi], dl

        $sequence_15 = { 8b542438 6888130000 52 ff15???????? }
            // n = 4, score = 100
            //   8b542438             | mov                 edx, dword ptr [esp + 0x38]
            //   6888130000           | push                0x1388
            //   52                   | push                edx
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 10817536
}