rule win_kimjongrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kimjongrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kimjongrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb13 ff37 6a00 ff771c 52 ff7508 e8???????? }
            // n = 7, score = 100
            //   eb13                 | jmp                 0x15
            //   ff37                 | push                dword ptr [edi]
            //   6a00                 | push                0
            //   ff771c               | push                dword ptr [edi + 0x1c]
            //   52                   | push                edx
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_1 = { 85c9 740e 51 50 e8???????? 83c408 0bf8 }
            // n = 7, score = 100
            //   85c9                 | test                ecx, ecx
            //   740e                 | je                  0x10
            //   51                   | push                ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   0bf8                 | or                  edi, eax

        $sequence_2 = { e9???????? c6840decfbffff64 e9???????? c6840decfbffff70 e9???????? c6840decfbffff73 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   c6840decfbffff64     | mov                 byte ptr [ebp + ecx - 0x414], 0x64
            //   e9????????           |                     
            //   c6840decfbffff70     | mov                 byte ptr [ebp + ecx - 0x414], 0x70
            //   e9????????           |                     
            //   c6840decfbffff73     | mov                 byte ptr [ebp + ecx - 0x414], 0x73
            //   e9????????           |                     

        $sequence_3 = { c6840db0abffff29 e9???????? c6840db0abffff3b e9???????? c6840db0abffff2b e9???????? c6840db0abffff3e }
            // n = 7, score = 100
            //   c6840db0abffff29     | mov                 byte ptr [ebp + ecx - 0x5450], 0x29
            //   e9????????           |                     
            //   c6840db0abffff3b     | mov                 byte ptr [ebp + ecx - 0x5450], 0x3b
            //   e9????????           |                     
            //   c6840db0abffff2b     | mov                 byte ptr [ebp + ecx - 0x5450], 0x2b
            //   e9????????           |                     
            //   c6840db0abffff3e     | mov                 byte ptr [ebp + ecx - 0x5450], 0x3e

        $sequence_4 = { 8b43e8 0343e4 8943cc e9???????? 8d4304 50 8d73d4 }
            // n = 7, score = 100
            //   8b43e8               | mov                 eax, dword ptr [ebx - 0x18]
            //   0343e4               | add                 eax, dword ptr [ebx - 0x1c]
            //   8943cc               | mov                 dword ptr [ebx - 0x34], eax
            //   e9????????           |                     
            //   8d4304               | lea                 eax, [ebx + 4]
            //   50                   | push                eax
            //   8d73d4               | lea                 esi, [ebx - 0x2c]

        $sequence_5 = { 8bd7 85d2 7464 8b4d08 8b4908 8b491c 8b4910 }
            // n = 7, score = 100
            //   8bd7                 | mov                 edx, edi
            //   85d2                 | test                edx, edx
            //   7464                 | je                  0x66
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b4908               | mov                 ecx, dword ptr [ecx + 8]
            //   8b491c               | mov                 ecx, dword ptr [ecx + 0x1c]
            //   8b4910               | mov                 ecx, dword ptr [ecx + 0x10]

        $sequence_6 = { beff1f0000 6685700c 8b75c8 741c 6a00 52 57 }
            // n = 7, score = 100
            //   beff1f0000           | mov                 esi, 0x1fff
            //   6685700c             | test                word ptr [eax + 0xc], si
            //   8b75c8               | mov                 esi, dword ptr [ebp - 0x38]
            //   741c                 | je                  0x1e
            //   6a00                 | push                0
            //   52                   | push                edx
            //   57                   | push                edi

        $sequence_7 = { 8b5d08 807b4201 0f859d000000 8a5340 f6c202 0f8491000000 8b4b10 }
            // n = 7, score = 100
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   807b4201             | cmp                 byte ptr [ebx + 0x42], 1
            //   0f859d000000         | jne                 0xa3
            //   8a5340               | mov                 dl, byte ptr [ebx + 0x40]
            //   f6c202               | test                dl, 2
            //   0f8491000000         | je                  0x97
            //   8b4b10               | mov                 ecx, dword ptr [ebx + 0x10]

        $sequence_8 = { e9???????? 6a01 ff73b4 57 e8???????? ff73c4 ff73f4 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   6a01                 | push                1
            //   ff73b4               | push                dword ptr [ebx - 0x4c]
            //   57                   | push                edi
            //   e8????????           |                     
            //   ff73c4               | push                dword ptr [ebx - 0x3c]
            //   ff73f4               | push                dword ptr [ebx - 0xc]

        $sequence_9 = { e8???????? 8b5d10 53 6a00 6a4f ff75f8 8bf8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   6a4f                 | push                0x4f
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   8bf8                 | mov                 edi, eax

    condition:
        7 of them and filesize < 1572864
}