rule win_kingminer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kingminer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kingminer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945f0 c745f400000000 3b0d???????? 0f8d8e010000 68???????? ff15???????? }
            // n = 6, score = 100
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   3b0d????????         |                     
            //   0f8d8e010000         | jge                 0x194
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_1 = { 8b8db0feffff e8???????? 8b95d8feffff 8b8db0feffff 52 8bf0 e8???????? }
            // n = 7, score = 100
            //   8b8db0feffff         | mov                 ecx, dword ptr [ebp - 0x150]
            //   e8????????           |                     
            //   8b95d8feffff         | mov                 edx, dword ptr [ebp - 0x128]
            //   8b8db0feffff         | mov                 ecx, dword ptr [ebp - 0x150]
            //   52                   | push                edx
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     

        $sequence_2 = { 53 8b5f38 f6c301 7570 0fb74706 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   8b5f38               | mov                 ebx, dword ptr [edi + 0x38]
            //   f6c301               | test                bl, 1
            //   7570                 | jne                 0x72
            //   0fb74706             | movzx               eax, word ptr [edi + 6]

        $sequence_3 = { 0fb75714 8d4c3a24 85c0 7429 8bf0 }
            // n = 5, score = 100
            //   0fb75714             | movzx               edx, word ptr [edi + 0x14]
            //   8d4c3a24             | lea                 ecx, [edx + edi + 0x24]
            //   85c0                 | test                eax, eax
            //   7429                 | je                  0x2b
            //   8bf0                 | mov                 esi, eax

        $sequence_4 = { 52 e9???????? a1???????? 6800040000 }
            // n = 4, score = 100
            //   52                   | push                edx
            //   e9????????           |                     
            //   a1????????           |                     
            //   6800040000           | push                0x400

        $sequence_5 = { 3bf0 741e 68c1000000 ff15???????? 5b }
            // n = 5, score = 100
            //   3bf0                 | cmp                 esi, eax
            //   741e                 | je                  0x20
            //   68c1000000           | push                0xc1
            //   ff15????????         |                     
            //   5b                   | pop                 ebx

        $sequence_6 = { 68???????? ff15???????? 8b7508 c7465c88d00010 }
            // n = 4, score = 100
            //   68????????           |                     
            //   ff15????????         |                     
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   c7465c88d00010       | mov                 dword ptr [esi + 0x5c], 0x1000d088

        $sequence_7 = { 8b0d???????? 8945ec 8b4624 83c628 }
            // n = 4, score = 100
            //   8b0d????????         |                     
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b4624               | mov                 eax, dword ptr [esi + 0x24]
            //   83c628               | add                 esi, 0x28

        $sequence_8 = { 8975e4 33c0 39b8a0f70010 0f8491000000 }
            // n = 4, score = 100
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi
            //   33c0                 | xor                 eax, eax
            //   39b8a0f70010         | cmp                 dword ptr [eax + 0x1000f7a0], edi
            //   0f8491000000         | je                  0x97

        $sequence_9 = { 8b95d0feffff 2b4234 7419 83b9a000000000 7466 50 }
            // n = 6, score = 100
            //   8b95d0feffff         | mov                 edx, dword ptr [ebp - 0x130]
            //   2b4234               | sub                 eax, dword ptr [edx + 0x34]
            //   7419                 | je                  0x1b
            //   83b9a000000000       | cmp                 dword ptr [ecx + 0xa0], 0
            //   7466                 | je                  0x68
            //   50                   | push                eax

    condition:
        7 of them and filesize < 165888
}