rule win_kins_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kins."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kins"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5f 5e 5b c9 c3 ff0d???????? 7518 }
            // n = 7, score = 5000
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c3                   | ret                 
            //   ff0d????????         |                     
            //   7518                 | jne                 0x1a

        $sequence_1 = { e8???????? 6a2e 8d7b18 57 e8???????? 84c0 743e }
            // n = 7, score = 5000
            //   e8????????           |                     
            //   6a2e                 | push                0x2e
            //   8d7b18               | lea                 edi, [ebx + 0x18]
            //   57                   | push                edi
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   743e                 | je                  0x40

        $sequence_2 = { 8b4d0c 890491 42 33c0 85f6 75c2 8b4510 }
            // n = 7, score = 5000
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   890491               | mov                 dword ptr [ecx + edx*4], eax
            //   42                   | inc                 edx
            //   33c0                 | xor                 eax, eax
            //   85f6                 | test                esi, esi
            //   75c2                 | jne                 0xffffffc4
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_3 = { 33da 035dec 897dfc 8d84032211906b c1c007 03c7 8bfe }
            // n = 7, score = 5000
            //   33da                 | xor                 ebx, edx
            //   035dec               | add                 ebx, dword ptr [ebp - 0x14]
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   8d84032211906b       | lea                 eax, [ebx + eax + 0x6b901122]
            //   c1c007               | rol                 eax, 7
            //   03c7                 | add                 eax, edi
            //   8bfe                 | mov                 edi, esi

        $sequence_4 = { 89441904 33c0 eb03 33c0 40 5f }
            // n = 6, score = 5000
            //   89441904             | mov                 dword ptr [ecx + ebx + 4], eax
            //   33c0                 | xor                 eax, eax
            //   eb03                 | jmp                 5
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   5f                   | pop                 edi

        $sequence_5 = { e8???????? 8bf0 85f6 0f8512010000 8d45dc 8bd8 e8???????? }
            // n = 7, score = 5000
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   0f8512010000         | jne                 0x118
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   8bd8                 | mov                 ebx, eax
            //   e8????????           |                     

        $sequence_6 = { e8???????? 33ff 85ff 7526 837c242800 0f85cefeffff 8b7508 }
            // n = 7, score = 5000
            //   e8????????           |                     
            //   33ff                 | xor                 edi, edi
            //   85ff                 | test                edi, edi
            //   7526                 | jne                 0x28
            //   837c242800           | cmp                 dword ptr [esp + 0x28], 0
            //   0f85cefeffff         | jne                 0xfffffed4
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]

        $sequence_7 = { 56 ffd7 833d????????04 720a 56 }
            // n = 5, score = 5000
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   833d????????04       |                     
            //   720a                 | jb                  0xc
            //   56                   | push                esi

        $sequence_8 = { 7510 837de801 750a 8b4720 894714 c645ff01 8a45ff }
            // n = 7, score = 5000
            //   7510                 | jne                 0x12
            //   837de801             | cmp                 dword ptr [ebp - 0x18], 1
            //   750a                 | jne                 0xc
            //   8b4720               | mov                 eax, dword ptr [edi + 0x20]
            //   894714               | mov                 dword ptr [edi + 0x14], eax
            //   c645ff01             | mov                 byte ptr [ebp - 1], 1
            //   8a45ff               | mov                 al, byte ptr [ebp - 1]

        $sequence_9 = { 72f0 8d411c e8???????? 83611800 }
            // n = 4, score = 5000
            //   72f0                 | jb                  0xfffffff2
            //   8d411c               | lea                 eax, [ecx + 0x1c]
            //   e8????????           |                     
            //   83611800             | and                 dword ptr [ecx + 0x18], 0

    condition:
        7 of them and filesize < 548864
}