rule win_kiwistealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kiwistealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kiwistealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4585c9 7462 4183e901 740f 4183f901 0f85d6000000 }
            // n = 6, score = 100
            //   4585c9               | lea                 eax, [esp + 0x250]
            //   7462                 | je                  0x2d4
            //   4183e901             | inc                 ebp
            //   740f                 | xor                 eax, eax
            //   4183f901             | dec                 eax
            //   0f85d6000000         | mov                 ecx, dword ptr [ecx + 0x28]

        $sequence_1 = { 4885c0 740e 488d7027 4883e6e0 488946f8 eb14 ff15???????? }
            // n = 7, score = 100
            //   4885c0               | dec                 eax
            //   740e                 | cmp                 edx, 0x1000
            //   488d7027             | dec                 eax
            //   4883e6e0             | mov                 eax, ecx
            //   488946f8             | jb                  0xd0
            //   eb14                 | dec                 eax
            //   ff15????????         |                     

        $sequence_2 = { 488b05???????? 4885c9 480f45c1 483b05???????? 747e 4c8bc6 488d542470 }
            // n = 7, score = 100
            //   488b05????????       |                     
            //   4885c9               | dec                 eax
            //   480f45c1             | test                eax, eax
            //   483b05????????       |                     
            //   747e                 | jne                 0x73
            //   4c8bc6               | dec                 eax
            //   488d542470           | mov                 dword ptr [ebx + 0x98], ebp

        $sequence_3 = { 0f118424b0020000 0f104810 0f118c24c0020000 4c896010 48c740180f000000 c60000 4c8d8c2458030000 }
            // n = 7, score = 100
            //   0f118424b0020000     | movups              xmmword ptr [ebx + 0x10], xmm1
            //   0f104810             | inc                 ecx
            //   0f118c24c0020000     | movups              xmmword ptr [ecx], xmm2
            //   4c896010             | inc                 ecx
            //   48c740180f000000     | movups              xmmword ptr [ecx + 0x10], xmm3
            //   c60000               | dec                 ecx
            //   4c8d8c2458030000     | cmp                 dword ptr [ecx + 0x18], 8

        $sequence_4 = { e9???????? 4983c5c0 4c896c2428 493bdc 0f85bc000000 4983ee40 4c89742420 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4983c5c0             | mov                 dword ptr [esp + 0x60], ebp
            //   4c896c2428           | dec                 eax
            //   493bdc               | lea                 edx, [0x25f77]
            //   0f85bc000000         | dec                 eax
            //   4983ee40             | lea                 ecx, [ebp + 0x278]
            //   4c89742420           | dec                 esp

        $sequence_5 = { e8???????? 43c6042e00 4533f6 488d45d8 48837df010 480f4345d8 4c89742438 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   43c6042e00           | dec                 eax
            //   4533f6               | lea                 eax, [0xc2e7]
            //   488d45d8             | dec                 eax
            //   48837df010           | mov                 dword ptr [ebx + 0x48], eax
            //   480f4345d8           | dec                 eax
            //   4c89742438           | mov                 eax, dword ptr [ebx + 0x70]

        $sequence_6 = { 488b05???????? 488905???????? 488d0d3d110200 e8???????? 8bc8 486bc10b 83f803 }
            // n = 7, score = 100
            //   488b05????????       |                     
            //   488905????????       |                     
            //   488d0d3d110200       | mov                 dword ptr [esp + 0x20], ebp
            //   e8????????           |                     
            //   8bc8                 | mov                 byte ptr [esp + 0x24], 0
            //   486bc10b             | dec                 eax
            //   83f803               | mov                 dword ptr [ebx + 0x90], eax

        $sequence_7 = { 0f118590000000 418d4c2440 e8???????? 488bd8 4889442428 33d2 488bc8 }
            // n = 7, score = 100
            //   0f118590000000       | jne                 0x365
            //   418d4c2440           | dec                 eax
            //   e8????????           |                     
            //   488bd8               | mov                 dword ptr [edx + 0x10], 0xc
            //   4889442428           | inc                 esp
            //   33d2                 | lea                 eax, [ecx + 0xc]
            //   488bc8               | dec                 eax

        $sequence_8 = { 41c70005000000 49894008 498bc0 41c6400401 c3 8bca 81e9d4040000 }
            // n = 7, score = 100
            //   41c70005000000       | dec                 eax
            //   49894008             | mov                 eax, ebx
            //   498bc0               | dec                 eax
            //   41c6400401           | mov                 ebx, dword ptr [esp + 0x50]
            //   c3                   | dec                 eax
            //   8bca                 | add                 esp, 0x20
            //   81e9d4040000         | inc                 ecx

        $sequence_9 = { 4883ec70 488bf9 4533f6 44897098 488d2db0920000 488968a0 0f57c0 }
            // n = 7, score = 100
            //   4883ec70             | lea                 eax, [0xaff0]
            //   488bf9               | dec                 eax
            //   4533f6               | mov                 dword ptr [ecx], eax
            //   44897098             | dec                 eax
            //   488d2db0920000       | lea                 eax, [0xb2ce]
            //   488968a0             | dec                 eax
            //   0f57c0               | mov                 dword ptr [ecx + 0x18], eax

    condition:
        7 of them and filesize < 403456
}