rule win_kk_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kk_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kk_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8a4510 53 56 8bf1 57 8b7d08 8886d4000000 }
            // n = 7, score = 100
            //   8a4510               | mov                 al, byte ptr [ebp + 0x10]
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8886d4000000         | mov                 byte ptr [esi + 0xd4], al

        $sequence_1 = { 8d85f4fdffff 68???????? 50 e8???????? 8d85f8feffff 50 8d85f4fdffff }
            // n = 7, score = 100
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]

        $sequence_2 = { bb01000000 8b461c 83782c00 7421 8b4614 3bc2 761a }
            // n = 7, score = 100
            //   bb01000000           | mov                 ebx, 1
            //   8b461c               | mov                 eax, dword ptr [esi + 0x1c]
            //   83782c00             | cmp                 dword ptr [eax + 0x2c], 0
            //   7421                 | je                  0x23
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   3bc2                 | cmp                 eax, edx
            //   761a                 | jbe                 0x1c

        $sequence_3 = { 7524 a1???????? a3???????? a1???????? c705????????24961010 8935???????? }
            // n = 6, score = 100
            //   7524                 | jne                 0x26
            //   a1????????           |                     
            //   a3????????           |                     
            //   a1????????           |                     
            //   c705????????24961010     |     
            //   8935????????         |                     

        $sequence_4 = { 51 8b4508 b94d5a0000 66c7004d5a 663908 7404 33c0 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   b94d5a0000           | mov                 ecx, 0x5a4d
            //   66c7004d5a           | mov                 word ptr [eax], 0x5a4d
            //   663908               | cmp                 word ptr [eax], cx
            //   7404                 | je                  6
            //   33c0                 | xor                 eax, eax

        $sequence_5 = { ff15???????? 53 50 8985ecfdffff 899de8fdffff ff15???????? }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   50                   | push                eax
            //   8985ecfdffff         | mov                 dword ptr [ebp - 0x214], eax
            //   899de8fdffff         | mov                 dword ptr [ebp - 0x218], ebx
            //   ff15????????         |                     

        $sequence_6 = { 741c 8d45cc 50 c745cc0b000000 c745f03ce51210 e8???????? 85c0 }
            // n = 7, score = 100
            //   741c                 | je                  0x1e
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   c745cc0b000000       | mov                 dword ptr [ebp - 0x34], 0xb
            //   c745f03ce51210       | mov                 dword ptr [ebp - 0x10], 0x1012e53c
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_7 = { 885dda c78504ffffff5245475f c78508ffffff45585041 c7850cffffff4e445f53 66c78510ffffff5a00 c78574ffffff5245475f c78578ffffff44574f52 }
            // n = 7, score = 100
            //   885dda               | mov                 byte ptr [ebp - 0x26], bl
            //   c78504ffffff5245475f     | mov    dword ptr [ebp - 0xfc], 0x5f474552
            //   c78508ffffff45585041     | mov    dword ptr [ebp - 0xf8], 0x41505845
            //   c7850cffffff4e445f53     | mov    dword ptr [ebp - 0xf4], 0x535f444e
            //   66c78510ffffff5a00     | mov    word ptr [ebp - 0xf0], 0x5a
            //   c78574ffffff5245475f     | mov    dword ptr [ebp - 0x8c], 0x5f474552
            //   c78578ffffff44574f52     | mov    dword ptr [ebp - 0x88], 0x524f5744

        $sequence_8 = { 897dfc 8b3d???????? ffd7 6a01 ff35???????? 8d8dbc60ffff ff35???????? }
            // n = 7, score = 100
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   8b3d????????         |                     
            //   ffd7                 | call                edi
            //   6a01                 | push                1
            //   ff35????????         |                     
            //   8d8dbc60ffff         | lea                 ecx, [ebp - 0x9f44]
            //   ff35????????         |                     

        $sequence_9 = { 8bf1 837e1410 57 7202 8b0e 8b450c }
            // n = 6, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   837e1410             | cmp                 dword ptr [esi + 0x14], 0x10
            //   57                   | push                edi
            //   7202                 | jb                  4
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

    condition:
        7 of them and filesize < 3516416
}