rule win_knight_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.knight."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.knight"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb7a 4889bc24a8010000 4889b424b0010000 c644243700 488b9424c8010000 488b02 ffd0 }
            // n = 7, score = 100
            //   eb7a                 | mov                 edi, dword ptr [esp + 0x58]
            //   4889bc24a8010000     | dec                 esp
            //   4889b424b0010000     | mov                 dword ptr [esp + 0x50], ecx
            //   c644243700           | mov                 byte ptr [esp + 0x46], al
            //   488b9424c8010000     | dec                 esp
            //   488b02               | mov                 eax, edx
            //   ffd0                 | mov                 edi, 1

        $sequence_1 = { e9???????? e8???????? 48898424d8000000 48899c2488000000 90 488d05b9951400 e8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   e8????????           |                     
            //   48898424d8000000     | dec                 ecx
            //   48899c2488000000     | mov                 dword ptr [esi + 0x10], 0xfffffade
            //   90                   | dec                 eax
            //   488d05b9951400       | mov                 ebp, dword ptr [esp + 0x10]
            //   e8????????           |                     

        $sequence_2 = { eb0a 488d3555d71700 4889c7 4c8b87c0000000 4c8b8fc8000000 0f1f4000 4d85c0 }
            // n = 7, score = 100
            //   eb0a                 | jbe                 0x17d1
            //   488d3555d71700       | movzx               esi, byte ptr [ebx + edx + 4]
            //   4889c7               | dec                 eax
            //   4c8b87c0000000       | lea                 eax, [ebx + 5]
            //   4c8b8fc8000000       | dec                 eax
            //   0f1f4000             | cmp                 ecx, eax
            //   4d85c0               | dec                 ebx

        $sequence_3 = { eb1c 4889c7 488b8c24e0230000 e8???????? 488d3dcf083000 e8???????? 6690 }
            // n = 7, score = 100
            //   eb1c                 | dec                 esp
            //   4889c7               | mov                 dword ptr [esp + 0x48], eax
            //   488b8c24e0230000     | dec                 esp
            //   e8????????           |                     
            //   488d3dcf083000       | mov                 dword ptr [esp + 0x50], ecx
            //   e8????????           |                     
            //   6690                 | inc                 esp

        $sequence_4 = { 4d3b6610 0f86a3010000 4881eca0000000 4889ac2498000000 488dac2498000000 48bae36f8e02db14e6c7 488954241f }
            // n = 7, score = 100
            //   4d3b6610             | dec                 eax
            //   0f86a3010000         | mov                 edx, eax
            //   4881eca0000000       | mov                 eax, 0xfffffffa
            //   4889ac2498000000     | call                ecx
            //   488dac2498000000     | dec                 eax
            //   48bae36f8e02db14e6c7     | mov    ecx, dword ptr [eax]
            //   488954241f           | dec                 eax

        $sequence_5 = { 90 e8???????? e8???????? 4889c1 4889df 488d0589551f00 488b9c2400070000 }
            // n = 7, score = 100
            //   90                   | lea                 eax, [0x2c5a83]
            //   e8????????           |                     
            //   e8????????           |                     
            //   4889c1               | nop                 dword ptr [eax]
            //   4889df               | dec                 eax
            //   488d0589551f00       | lea                 ecx, [0x254]
            //   488b9c2400070000     | dec                 eax

        $sequence_6 = { eb0c 488d3da69a4c00 e8???????? e8???????? 48891d???????? 833d????????00 7509 }
            // n = 7, score = 100
            //   eb0c                 | dec                 ecx
            //   488d3da69a4c00       | imul                ecx, ecx
            //   e8????????           |                     
            //   e8????????           |                     
            //   48891d????????       |                     
            //   833d????????00       |                     
            //   7509                 | dec                 esp

        $sequence_7 = { ffc2 85d2 7d10 488d057e863800 31db 31c9 e8???????? }
            // n = 7, score = 100
            //   ffc2                 | dec                 ecx
            //   85d2                 | neg                 ecx
            //   7d10                 | dec                 ecx
            //   488d057e863800       | sar                 ecx, 0x3f
            //   31db                 | dec                 ecx
            //   31c9                 | inc                 edx
            //   e8????????           |                     

        $sequence_8 = { ffd1 4889842438010000 48899c2490000000 488d0517dd1700 e8???????? 488b8c2490000000 48894808 }
            // n = 7, score = 100
            //   ffd1                 | mov                 eax, dword ptr [ecx + 0x30]
            //   4889842438010000     | dec                 esp
            //   48899c2490000000     | mov                 dword ptr [esp + 0x28], esi
            //   488d0517dd1700       | dec                 ecx
            //   e8????????           |                     
            //   488b8c2490000000     | mov                 ecx, dword ptr [esi + 0x170]
            //   48894808             | dec                 eax

        $sequence_9 = { e8???????? f20f108424f0000000 f20f108c24c0000000 0f57d2 660f2ed0 7613 f20f101d???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   f20f108424f0000000     | xor    eax, eax
            //   f20f108c24c0000000     | dec    eax
            //   0f57d2               | mov                 ebx, dword ptr [esp + 0x120]
            //   660f2ed0             | dec                 eax
            //   7613                 | mov                 ebp, dword ptr [esp + 0x1a8]
            //   f20f101d????????     |                     

    condition:
        7 of them and filesize < 12149760
}