rule win_knot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.knot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.knot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7407 c685f3fdffff00 ebbe 0fb68df3fdffff 83f901 }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   c685f3fdffff00       | mov                 byte ptr [ebp - 0x20d], 0
            //   ebbe                 | jmp                 0xffffffc0
            //   0fb68df3fdffff       | movzx               ecx, byte ptr [ebp - 0x20d]
            //   83f901               | cmp                 ecx, 1

        $sequence_1 = { ff15???????? 85c0 0f855ffdffff 8b958cf9ffff }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f855ffdffff         | jne                 0xfffffd65
            //   8b958cf9ffff         | mov                 edx, dword ptr [ebp - 0x674]

        $sequence_2 = { 6a00 6a02 6a00 8b4df8 51 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   6a00                 | push                0
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   51                   | push                ecx

        $sequence_3 = { 8bec 81ec24020000 e8???????? 8945fc c785ecfdffff02000000 }
            // n = 5, score = 200
            //   8bec                 | mov                 ebp, esp
            //   81ec24020000         | sub                 esp, 0x224
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   c785ecfdffff02000000     | mov    dword ptr [ebp - 0x214], 2

        $sequence_4 = { 7507 32c0 e9???????? 6a00 6a00 6a00 6a02 }
            // n = 7, score = 200
            //   7507                 | jne                 9
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a02                 | push                2

        $sequence_5 = { 8d8dd0fdffff 51 6a08 8d95c8fdffff }
            // n = 4, score = 200
            //   8d8dd0fdffff         | lea                 ecx, [ebp - 0x230]
            //   51                   | push                ecx
            //   6a08                 | push                8
            //   8d95c8fdffff         | lea                 edx, [ebp - 0x238]

        $sequence_6 = { 7454 6a00 6a00 6a00 6a04 8b55f4 52 }
            // n = 7, score = 200
            //   7454                 | je                  0x56
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx

        $sequence_7 = { 83c40c 8985e8fdffff 8b8de8fdffff 898ddcfdffff 83bddcfdffff03 7402 }
            // n = 6, score = 200
            //   83c40c               | add                 esp, 0xc
            //   8985e8fdffff         | mov                 dword ptr [ebp - 0x218], eax
            //   8b8de8fdffff         | mov                 ecx, dword ptr [ebp - 0x218]
            //   898ddcfdffff         | mov                 dword ptr [ebp - 0x224], ecx
            //   83bddcfdffff03       | cmp                 dword ptr [ebp - 0x224], 3
            //   7402                 | je                  4

        $sequence_8 = { 6a00 6a00 6800000040 8d95e0fdffff }
            // n = 4, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6800000040           | push                0x40000000
            //   8d95e0fdffff         | lea                 edx, [ebp - 0x220]

        $sequence_9 = { e8???????? 8985d0feffff e9???????? 8b8dd4feffff 51 ff15???????? 8be5 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8985d0feffff         | mov                 dword ptr [ebp - 0x130], eax
            //   e9????????           |                     
            //   8b8dd4feffff         | mov                 ecx, dword ptr [ebp - 0x12c]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8be5                 | mov                 esp, ebp

    condition:
        7 of them and filesize < 59392
}