rule win_komprogo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.komprogo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.komprogo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 68???????? 8d45f4 50 c745f400614100 e8???????? cc }
            // n = 7, score = 100
            //   e8????????           |                     
            //   68????????           |                     
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   c745f400614100       | mov                 dword ptr [ebp - 0xc], 0x416100
            //   e8????????           |                     
            //   cc                   | int3                

        $sequence_1 = { c745ec00000000 84c0 7407 be01000000 eb15 51 e8???????? }
            // n = 7, score = 100
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   84c0                 | test                al, al
            //   7407                 | je                  9
            //   be01000000           | mov                 esi, 1
            //   eb15                 | jmp                 0x17
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_2 = { 899ef6e80000 899eeca10000 8d8610700300 8986aee90000 8d861c970300 898632ea0000 }
            // n = 6, score = 100
            //   899ef6e80000         | mov                 dword ptr [esi + 0xe8f6], ebx
            //   899eeca10000         | mov                 dword ptr [esi + 0xa1ec], ebx
            //   8d8610700300         | lea                 eax, [esi + 0x37010]
            //   8986aee90000         | mov                 dword ptr [esi + 0xe9ae], eax
            //   8d861c970300         | lea                 eax, [esi + 0x3971c]
            //   898632ea0000         | mov                 dword ptr [esi + 0xea32], eax

        $sequence_3 = { 8d55f0 52 8b11 8d45f4 50 52 }
            // n = 6, score = 100
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   52                   | push                edx
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   52                   | push                edx

        $sequence_4 = { 899e876b0000 51 8b4dfc 899e9a6b0000 8d8696d20300 }
            // n = 5, score = 100
            //   899e876b0000         | mov                 dword ptr [esi + 0x6b87], ebx
            //   51                   | push                ecx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   899e9a6b0000         | mov                 dword ptr [esi + 0x6b9a], ebx
            //   8d8696d20300         | lea                 eax, [esi + 0x3d296]

        $sequence_5 = { 8d85e4f3ffff 50 8d8decfdffff 51 c78584f3ffff44000000 ff15???????? 8bf0 }
            // n = 7, score = 100
            //   8d85e4f3ffff         | lea                 eax, [ebp - 0xc1c]
            //   50                   | push                eax
            //   8d8decfdffff         | lea                 ecx, [ebp - 0x214]
            //   51                   | push                ecx
            //   c78584f3ffff44000000     | mov    dword ptr [ebp - 0xc7c], 0x44
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_6 = { 51 8d86a0d00300 8bcb e8???????? 83c404 84c0 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   8d86a0d00300         | lea                 eax, [esi + 0x3d0a0]
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   84c0                 | test                al, al

        $sequence_7 = { 8d8650e60300 8d961ef30100 898623bc0200 899634320200 8d8636a50200 898675af0200 }
            // n = 6, score = 100
            //   8d8650e60300         | lea                 eax, [esi + 0x3e650]
            //   8d961ef30100         | lea                 edx, [esi + 0x1f31e]
            //   898623bc0200         | mov                 dword ptr [esi + 0x2bc23], eax
            //   899634320200         | mov                 dword ptr [esi + 0x23234], edx
            //   8d8636a50200         | lea                 eax, [esi + 0x2a536]
            //   898675af0200         | mov                 dword ptr [esi + 0x2af75], eax

        $sequence_8 = { 8d8ee0920000 898e1caa0300 8d8e80720300 8d96305d0300 51 8b4df4 8d8600cf0300 }
            // n = 7, score = 100
            //   8d8ee0920000         | lea                 ecx, [esi + 0x92e0]
            //   898e1caa0300         | mov                 dword ptr [esi + 0x3aa1c], ecx
            //   8d8e80720300         | lea                 ecx, [esi + 0x37280]
            //   8d96305d0300         | lea                 edx, [esi + 0x35d30]
            //   51                   | push                ecx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8d8600cf0300         | lea                 eax, [esi + 0x3cf00]

        $sequence_9 = { 89966c940300 8d9698ec0300 89964da90200 898e88aa0200 8986cbaa0200 8d860cea0300 8986f7aa0200 }
            // n = 7, score = 100
            //   89966c940300         | mov                 dword ptr [esi + 0x3946c], edx
            //   8d9698ec0300         | lea                 edx, [esi + 0x3ec98]
            //   89964da90200         | mov                 dword ptr [esi + 0x2a94d], edx
            //   898e88aa0200         | mov                 dword ptr [esi + 0x2aa88], ecx
            //   8986cbaa0200         | mov                 dword ptr [esi + 0x2aacb], eax
            //   8d860cea0300         | lea                 eax, [esi + 0x3ea0c]
            //   8986f7aa0200         | mov                 dword ptr [esi + 0x2aaf7], eax

    condition:
        7 of them and filesize < 1045504
}