rule win_konni_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.konni."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.konni"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 50 8b45e8 0fb6cc 51 0fb6d0 52 }
            // n = 7, score = 800
            //   52                   | push                edx
            //   50                   | push                eax
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   0fb6cc               | movzx               ecx, ah
            //   51                   | push                ecx
            //   0fb6d0               | movzx               edx, al
            //   52                   | push                edx

        $sequence_1 = { 85c0 7527 0fb655eb 0fb645ea }
            // n = 4, score = 800
            //   85c0                 | test                eax, eax
            //   7527                 | jne                 0x29
            //   0fb655eb             | movzx               edx, byte ptr [ebp - 0x15]
            //   0fb645ea             | movzx               eax, byte ptr [ebp - 0x16]

        $sequence_2 = { 03c0 334604 03c0 334608 03c0 33460c 03c0 }
            // n = 7, score = 800
            //   03c0                 | add                 eax, eax
            //   334604               | xor                 eax, dword ptr [esi + 4]
            //   03c0                 | add                 eax, eax
            //   334608               | xor                 eax, dword ptr [esi + 8]
            //   03c0                 | add                 eax, eax
            //   33460c               | xor                 eax, dword ptr [esi + 0xc]
            //   03c0                 | add                 eax, eax

        $sequence_3 = { 83c418 8b45e4 50 ff15???????? }
            // n = 4, score = 800
            //   83c418               | add                 esp, 0x18
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_4 = { a1???????? 33c5 8945fc 8b0d???????? 8a15???????? 33c0 }
            // n = 6, score = 800
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b0d????????         |                     
            //   8a15????????         |                     
            //   33c0                 | xor                 eax, eax

        $sequence_5 = { 57 8b7d10 8985f4feffff 33f6 }
            // n = 4, score = 800
            //   57                   | push                edi
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   8985f4feffff         | mov                 dword ptr [ebp - 0x10c], eax
            //   33f6                 | xor                 esi, esi

        $sequence_6 = { 85c0 0f84f1000000 0f88eb000000 83f801 7508 }
            // n = 5, score = 800
            //   85c0                 | test                eax, eax
            //   0f84f1000000         | je                  0xf7
            //   0f88eb000000         | js                  0xf1
            //   83f801               | cmp                 eax, 1
            //   7508                 | jne                 0xa

        $sequence_7 = { 7908 49 81c900ffffff 41 8a940df8feffff }
            // n = 5, score = 800
            //   7908                 | jns                 0xa
            //   49                   | dec                 ecx
            //   81c900ffffff         | or                  ecx, 0xffffff00
            //   41                   | inc                 ecx
            //   8a940df8feffff       | mov                 dl, byte ptr [ebp + ecx - 0x108]

        $sequence_8 = { 83f801 750a c705????????01000000 890d???????? }
            // n = 4, score = 500
            //   83f801               | cmp                 eax, 1
            //   750a                 | jne                 0xc
            //   c705????????01000000     |     
            //   890d????????         |                     

        $sequence_9 = { 33c9 83f802 7508 890d???????? }
            // n = 4, score = 500
            //   33c9                 | xor                 ecx, ecx
            //   83f802               | cmp                 eax, 2
            //   7508                 | jne                 0xa
            //   890d????????         |                     

        $sequence_10 = { eb1e 83f804 740f c705????????02000000 }
            // n = 4, score = 500
            //   eb1e                 | jmp                 0x20
            //   83f804               | cmp                 eax, 4
            //   740f                 | je                  0x11
            //   c705????????02000000     |     

        $sequence_11 = { 6a01 ff15???????? 50 a3???????? }
            // n = 4, score = 500
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   50                   | push                eax
            //   a3????????           |                     

        $sequence_12 = { 68b6030000 6a0d 50 ff15???????? }
            // n = 4, score = 500
            //   68b6030000           | push                0x3b6
            //   6a0d                 | push                0xd
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_13 = { 7508 890d???????? eb1e 83f804 }
            // n = 4, score = 500
            //   7508                 | jne                 0xa
            //   890d????????         |                     
            //   eb1e                 | jmp                 0x20
            //   83f804               | cmp                 eax, 4

        $sequence_14 = { eb02 33c9 e8???????? 8bf8 }
            // n = 4, score = 400
            //   eb02                 | jne                 0xa
            //   33c9                 | jmp                 0x22
            //   e8????????           |                     
            //   8bf8                 | cmp                 eax, 4

        $sequence_15 = { 68???????? ffd6 83c8ff 5f 5e 5b 8b4dfc }
            // n = 7, score = 300
            //   68????????           |                     
            //   ffd6                 | xor                 ecx, ecx
            //   83c8ff               | cmp                 eax, 2
            //   5f                   | jne                 0xd
            //   5e                   | jmp                 0x25
            //   5b                   | cmp                 eax, 4
            //   8b4dfc               | jmp                 0x20

        $sequence_16 = { 0fb6591c 88581c 0fb6591d 88581d 0fb6591e }
            // n = 5, score = 300
            //   0fb6591c             | je                  0x14
            //   88581c               | cmp                 eax, 1
            //   0fb6591d             | xor                 ecx, ecx
            //   88581d               | cmp                 eax, 2
            //   0fb6591e             | jne                 0xd

        $sequence_17 = { ffd6 8b4d08 51 ffd6 53 ffd6 }
            // n = 6, score = 300
            //   ffd6                 | cmp                 eax, 1
            //   8b4d08               | jne                 0xa
            //   51                   | jmp                 0x20
            //   ffd6                 | cmp                 eax, 4
            //   53                   | jmp                 0x20
            //   ffd6                 | cmp                 eax, 4

        $sequence_18 = { 68???????? 8d8df0faffff 51 ffd6 8b35???????? 8d95f0faffff }
            // n = 6, score = 200
            //   68????????           |                     
            //   8d8df0faffff         | lea                 ecx, [ebp - 0x510]
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   8b35????????         |                     
            //   8d95f0faffff         | lea                 edx, [ebp - 0x510]

        $sequence_19 = { 8d8df8feffff 51 8d95f0fcffff 52 6a00 6a00 }
            // n = 6, score = 200
            //   8d8df8feffff         | lea                 ecx, [ebp - 0x108]
            //   51                   | push                ecx
            //   8d95f0fcffff         | lea                 edx, [ebp - 0x310]
            //   52                   | push                edx
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_20 = { 4c89742420 ff15???????? 488bd8 4885c0 744f }
            // n = 5, score = 200
            //   4c89742420           | dec                 esp
            //   ff15????????         |                     
            //   488bd8               | mov                 dword ptr [esp + 0x20], esi
            //   4885c0               | dec                 eax
            //   744f                 | mov                 ebx, eax

        $sequence_21 = { 8db768020000 8916 56 e8???????? 8a8c30dec44600 }
            // n = 5, score = 200
            //   8db768020000         | lea                 esi, [edi + 0x268]
            //   8916                 | mov                 dword ptr [esi], edx
            //   56                   | push                esi
            //   e8????????           |                     
            //   8a8c30dec44600       | mov                 cl, byte ptr [eax + esi + 0x46c4de]

        $sequence_22 = { 660f1f440000 498bc8 ba04000000 0f1f840000000000 0fb601 4883c104 48ffca }
            // n = 7, score = 200
            //   660f1f440000         | xor                 edx, edx
            //   498bc8               | dec                 eax
            //   ba04000000           | mov                 dword ptr [ebp - 0x40], eax
            //   0f1f840000000000     | dec                 eax
            //   0fb601               | lea                 eax, [ebp - 0x48]
            //   4883c104             | dec                 eax
            //   48ffca               | sub                 esi, eax

        $sequence_23 = { 8d8df4fdffff 51 ff15???????? 85c0 755b 57 }
            // n = 6, score = 200
            //   8d8df4fdffff         | lea                 ecx, [ebp - 0x20c]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   755b                 | jne                 0x5d
            //   57                   | push                edi

        $sequence_24 = { 52 6a00 6a00 ff15???????? 68d0070000 ff15???????? 8b4dfc }
            // n = 7, score = 200
            //   52                   | push                edx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   68d0070000           | push                0x7d0
            //   ff15????????         |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_25 = { ff15???????? 8b3d???????? be0a000000 68e8030000 ffd7 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   be0a000000           | mov                 esi, 0xa
            //   68e8030000           | push                0x3e8
            //   ffd7                 | call                edi

        $sequence_26 = { 6a00 8d8df8feffff 51 8d95f0fcffff }
            // n = 4, score = 200
            //   6a00                 | push                0
            //   8d8df8feffff         | lea                 ecx, [ebp - 0x108]
            //   51                   | push                ecx
            //   8d95f0fcffff         | lea                 edx, [ebp - 0x310]

        $sequence_27 = { d3ea 33c9 56 e8???????? 8a8c30a6c44600 }
            // n = 5, score = 200
            //   d3ea                 | shr                 edx, cl
            //   33c9                 | xor                 ecx, ecx
            //   56                   | push                esi
            //   e8????????           |                     
            //   8a8c30a6c44600       | mov                 cl, byte ptr [eax + esi + 0x46c4a6]

        $sequence_28 = { e8???????? 8a8c30dec44600 5e bb01000000 83c604 d3e3 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8a8c30dec44600       | mov                 cl, byte ptr [eax + esi + 0x46c4de]
            //   5e                   | pop                 esi
            //   bb01000000           | mov                 ebx, 1
            //   83c604               | add                 esi, 4
            //   d3e3                 | shl                 ebx, cl

        $sequence_29 = { 8a8664020000 8b9cae68020000 33d2 56 e8???????? 8a9435dec44600 5e }
            // n = 7, score = 200
            //   8a8664020000         | mov                 al, byte ptr [esi + 0x264]
            //   8b9cae68020000       | mov                 ebx, dword ptr [esi + ebp*4 + 0x268]
            //   33d2                 | xor                 edx, edx
            //   56                   | push                esi
            //   e8????????           |                     
            //   8a9435dec44600       | mov                 dl, byte ptr [ebp + esi + 0x46c4de]
            //   5e                   | pop                 esi

        $sequence_30 = { e8???????? 8a9435dec44600 5e 84c0 8bfa 7476 83ff03 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8a9435dec44600       | mov                 dl, byte ptr [ebp + esi + 0x46c4de]
            //   5e                   | pop                 esi
            //   84c0                 | test                al, al
            //   8bfa                 | mov                 edi, edx
            //   7476                 | je                  0x78
            //   83ff03               | cmp                 edi, 3

        $sequence_31 = { e8???????? 8a8c30a6c44600 5e 8b442414 03ca }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8a8c30a6c44600       | mov                 cl, byte ptr [eax + esi + 0x46c4a6]
            //   5e                   | pop                 esi
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   03ca                 | add                 ecx, edx

        $sequence_32 = { ff15???????? 488bcb ff15???????? 488d8c24e0000000 33d2 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   488bcb               | shl                 ecx, 8
            //   ff15????????         |                     
            //   488d8c24e0000000     | or                  ecx, eax
            //   33d2                 | inc                 ecx

        $sequence_33 = { 57 6804010000 8d95f8feffff 52 }
            // n = 4, score = 200
            //   57                   | push                edi
            //   6804010000           | push                0x104
            //   8d95f8feffff         | lea                 edx, [ebp - 0x108]
            //   52                   | push                edx

        $sequence_34 = { 488945c0 488d45b8 482bf0 6666666666660f1f840000000000 ba04000000 6666660f1f840000000000 0fb6040e }
            // n = 7, score = 200
            //   488945c0             | movzx               eax, byte ptr [eax - 7]
            //   488d45b8             | shl                 ecx, 8
            //   482bf0               | or                  ecx, eax
            //   6666666666660f1f840000000000     | dec    eax
            //   ba04000000           | mov                 ecx, ebx
            //   6666660f1f840000000000     | dec    eax
            //   0fb6040e             | lea                 ecx, [esp + 0xe0]

        $sequence_35 = { 33db 56 e8???????? 8a9c30c2c44600 5e 83f908 }
            // n = 6, score = 200
            //   33db                 | xor                 ebx, ebx
            //   56                   | push                esi
            //   e8????????           |                     
            //   8a9c30c2c44600       | mov                 bl, byte ptr [eax + esi + 0x46c4c2]
            //   5e                   | pop                 esi
            //   83f908               | cmp                 ecx, 8

        $sequence_36 = { 41b850000000 4533c9 488bd3 488bc8 c744242803000000 }
            // n = 5, score = 200
            //   41b850000000         | movzx               eax, byte ptr [ecx]
            //   4533c9               | dec                 eax
            //   488bd3               | add                 ecx, 4
            //   488bc8               | dec                 eax
            //   c744242803000000     | dec                 edx

        $sequence_37 = { 68???????? 8d95f8feffff 52 ffd6 6804010000 8d85f0fcffff 50 }
            // n = 7, score = 200
            //   68????????           |                     
            //   8d95f8feffff         | lea                 edx, [ebp - 0x108]
            //   52                   | push                edx
            //   ffd6                 | call                esi
            //   6804010000           | push                0x104
            //   8d85f0fcffff         | lea                 eax, [ebp - 0x310]
            //   50                   | push                eax

        $sequence_38 = { bbedffffff 03dd 81eb00200200 83bd9404000000 899d94040000 }
            // n = 5, score = 200
            //   bbedffffff           | mov                 ebx, 0xffffffed
            //   03dd                 | add                 ebx, ebp
            //   81eb00200200         | sub                 ebx, 0x22000
            //   83bd9404000000       | cmp                 dword ptr [ebp + 0x494], 0
            //   899d94040000         | mov                 dword ptr [ebp + 0x494], ebx

        $sequence_39 = { 8d3c85e0a30010 8bc3 80c901 83e01f 884d0b 8d34c0 8b07 }
            // n = 7, score = 100
            //   8d3c85e0a30010       | lea                 edi, [eax*4 + 0x1000a3e0]
            //   8bc3                 | mov                 eax, ebx
            //   80c901               | or                  cl, 1
            //   83e01f               | and                 eax, 0x1f
            //   884d0b               | mov                 byte ptr [ebp + 0xb], cl
            //   8d34c0               | lea                 esi, [eax + eax*8]
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_40 = { 8d0c9de0a30010 8d9080040000 8901 3bc2 7318 80600400 }
            // n = 6, score = 100
            //   8d0c9de0a30010       | lea                 ecx, [ebx*4 + 0x1000a3e0]
            //   8d9080040000         | lea                 edx, [eax + 0x480]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   3bc2                 | cmp                 eax, edx
            //   7318                 | jae                 0x1a
            //   80600400             | and                 byte ptr [eax + 4], 0

        $sequence_41 = { bb???????? 7539 e8???????? 68???????? 53 }
            // n = 5, score = 100
            //   bb????????           |                     
            //   7539                 | jne                 0x3b
            //   e8????????           |                     
            //   68????????           |                     
            //   53                   | push                ebx

        $sequence_42 = { 4963cb 41ffc1 48ffc3 0fb6040c 8843ff 40883c0c }
            // n = 6, score = 100
            //   4963cb               | dec                 ecx
            //   41ffc1               | arpl                dx, cx
            //   48ffc3               | movzx               eax, byte ptr [esp + ecx]
            //   0fb6040c             | inc                 edx
            //   8843ff               | mov                 byte ptr [esp + ecx], al
            //   40883c0c             | inc                 esp

        $sequence_43 = { 80a0a0a1001000 40 41 41 3bc6 72bf }
            // n = 6, score = 100
            //   80a0a0a1001000       | and                 byte ptr [eax + 0x1000a1a0], 0
            //   40                   | inc                 eax
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx
            //   3bc6                 | cmp                 eax, esi
            //   72bf                 | jb                  0xffffffc1

        $sequence_44 = { 4963ca 0fb6040c 4288040c 44881c0c 420fb60c0c 4103cb 81e1ff000080 }
            // n = 7, score = 100
            //   4963ca               | inc                 esp
            //   0fb6040c             | mov                 esp, eax
            //   4288040c             | test                eax, eax
            //   44881c0c             | jne                 0x32
            //   420fb60c0c           | dec                 esp
            //   4103cb               | mov                 dword ptr [esp + 0x20], esi
            //   81e1ff000080         | dec                 eax

        $sequence_45 = { 7468 488d44246c 4c8d8c2480010000 4c8d442430 488d15b1190100 }
            // n = 5, score = 100
            //   7468                 | mov                 eax, 0x50
            //   488d44246c           | inc                 ebp
            //   4c8d8c2480010000     | xor                 ecx, ecx
            //   4c8d442430           | dec                 eax
            //   488d15b1190100       | mov                 edx, ebx

        $sequence_46 = { 66c705????????0100 837e0811 7509 66c705????????0100 837e0856 7514 66833d????????01 }
            // n = 7, score = 100
            //   66c705????????0100     |     
            //   837e0811             | cmp                 dword ptr [esi + 8], 0x11
            //   7509                 | jne                 0xb
            //   66c705????????0100     |     
            //   837e0856             | cmp                 dword ptr [esi + 8], 0x56
            //   7514                 | jne                 0x16
            //   66833d????????01     |                     

        $sequence_47 = { 8b348de0a30010 8d1c8de0a30010 8d3cc0 c1e702 03f7 837e0800 }
            // n = 6, score = 100
            //   8b348de0a30010       | mov                 esi, dword ptr [ecx*4 + 0x1000a3e0]
            //   8d1c8de0a30010       | lea                 ebx, [ecx*4 + 0x1000a3e0]
            //   8d3cc0               | lea                 edi, [eax + eax*8]
            //   c1e702               | shl                 edi, 2
            //   03f7                 | add                 esi, edi
            //   837e0800             | cmp                 dword ptr [esi + 8], 0

        $sequence_48 = { 4c8bb42480180000 4c8ba42488180000 488bbc2490180000 4889742458 }
            // n = 4, score = 100
            //   4c8bb42480180000     | dec                 eax
            //   4c8ba42488180000     | mov                 ecx, eax
            //   488bbc2490180000     | mov                 dword ptr [esp + 0x28], 3
            //   4889742458           | inc                 ecx

        $sequence_49 = { 418bf1 8bea 458bda 418bc2 488d0c24 0f1f8000000000 8801 }
            // n = 7, score = 100
            //   418bf1               | mov                 eax, 0x50
            //   8bea                 | inc                 ebp
            //   458bda               | xor                 ecx, ecx
            //   418bc2               | dec                 eax
            //   488d0c24             | mov                 edx, ebx
            //   0f1f8000000000       | dec                 eax
            //   8801                 | mov                 ecx, eax

        $sequence_50 = { 85c0 0f85e0feffff 488bbc2430010000 488b9c2420010000 4c8ba42438010000 }
            // n = 5, score = 100
            //   85c0                 | mov                 ebx, eax
            //   0f85e0feffff         | dec                 eax
            //   488bbc2430010000     | test                eax, eax
            //   488b9c2420010000     | je                  0x54
            //   4c8ba42438010000     | inc                 ecx

    condition:
        7 of them and filesize < 2361344
}