rule win_koobface_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.koobface."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.koobface"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d85c8f3ffff 50 ffd6 8d85d8f3ffff 50 c645fc06 ffd6 }
            // n = 7, score = 100
            //   8d85c8f3ffff         | lea                 eax, [ebp - 0xc38]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8d85d8f3ffff         | lea                 eax, [ebp - 0xc28]
            //   50                   | push                eax
            //   c645fc06             | mov                 byte ptr [ebp - 4], 6
            //   ffd6                 | call                esi

        $sequence_1 = { 56 e8???????? 59 50 56 8d8f50010000 e8???????? }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   56                   | push                esi
            //   8d8f50010000         | lea                 ecx, [edi + 0x150]
            //   e8????????           |                     

        $sequence_2 = { 50 0fb78538c1ffff 50 ffb534c1ffff 8d85f0e8ffff ffb530c1ffff 68???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   0fb78538c1ffff       | movzx               eax, word ptr [ebp - 0x3ec8]
            //   50                   | push                eax
            //   ffb534c1ffff         | push                dword ptr [ebp - 0x3ecc]
            //   8d85f0e8ffff         | lea                 eax, [ebp - 0x1710]
            //   ffb530c1ffff         | push                dword ptr [ebp - 0x3ed0]
            //   68????????           |                     

        $sequence_3 = { 6874040000 b8???????? e8???????? 8b4508 }
            // n = 4, score = 100
            //   6874040000           | push                0x474
            //   b8????????           |                     
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_4 = { 8bd6 c1fa05 8b1495a0534200 83e61f c1e606 f644320480 7416 }
            // n = 7, score = 100
            //   8bd6                 | mov                 edx, esi
            //   c1fa05               | sar                 edx, 5
            //   8b1495a0534200       | mov                 edx, dword ptr [edx*4 + 0x4253a0]
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   f644320480           | test                byte ptr [edx + esi + 4], 0x80
            //   7416                 | je                  0x18

        $sequence_5 = { 5e 8bc3 5b 5d c20c00 e9???????? 55 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   8bc3                 | mov                 eax, ebx
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   e9????????           |                     
            //   55                   | push                ebp

        $sequence_6 = { ff91b4000000 ff75d8 ffd3 8b4514 3bc7 }
            // n = 5, score = 100
            //   ff91b4000000         | call                dword ptr [ecx + 0xb4]
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   ffd3                 | call                ebx
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   3bc7                 | cmp                 eax, edi

        $sequence_7 = { 50 e8???????? 68???????? 8d850857ffff 50 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   68????????           |                     
            //   8d850857ffff         | lea                 eax, [ebp - 0xa8f8]
            //   50                   | push                eax

        $sequence_8 = { 8906 3bc7 7425 6aeb 50 ff15???????? ff750c }
            // n = 7, score = 100
            //   8906                 | mov                 dword ptr [esi], eax
            //   3bc7                 | cmp                 eax, edi
            //   7425                 | je                  0x27
            //   6aeb                 | push                -0x15
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_9 = { ff11 8b45e0 c645fc02 85c0 7406 8b08 50 }
            // n = 7, score = 100
            //   ff11                 | call                dword ptr [ecx]
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   85c0                 | test                eax, eax
            //   7406                 | je                  8
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 368640
}