rule win_korlia_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.korlia."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.korlia"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a28 68???????? 6aff 53 }
            // n = 4, score = 2300
            //   6a28                 | push                0x28
            //   68????????           |                     
            //   6aff                 | push                -1
            //   53                   | push                ebx

        $sequence_1 = { 8bfa f7ef c1fa14 8bc2 c1e81f }
            // n = 5, score = 2300
            //   8bfa                 | mov                 edi, edx
            //   f7ef                 | imul                edi
            //   c1fa14               | sar                 edx, 0x14
            //   8bc2                 | mov                 eax, edx
            //   c1e81f               | shr                 eax, 0x1f

        $sequence_2 = { 0f9445e4 5b 59 5a c745fcffffffff }
            // n = 5, score = 2300
            //   0f9445e4             | sete                byte ptr [ebp - 0x1c]
            //   5b                   | pop                 ebx
            //   59                   | pop                 ecx
            //   5a                   | pop                 edx
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff

        $sequence_3 = { c3 85db 7410 6a28 }
            // n = 4, score = 2300
            //   c3                   | ret                 
            //   85db                 | test                ebx, ebx
            //   7410                 | je                  0x12
            //   6a28                 | push                0x28

        $sequence_4 = { 53 6a00 6a00 ffd6 ff15???????? 8bf8 b83bd4b531 }
            // n = 7, score = 2300
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ffd6                 | call                esi
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   b83bd4b531           | mov                 eax, 0x31b5d43b

        $sequence_5 = { 51 68???????? 68???????? ffd6 b905000000 }
            // n = 5, score = 2300
            //   51                   | push                ecx
            //   68????????           |                     
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   b905000000           | mov                 ecx, 5

        $sequence_6 = { 85c0 7507 53 ff15???????? 55 }
            // n = 5, score = 2300
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   55                   | push                ebp

        $sequence_7 = { ffd6 8bc7 b980ee3600 99 f7f9 b873b2e745 }
            // n = 6, score = 2300
            //   ffd6                 | call                esi
            //   8bc7                 | mov                 eax, edi
            //   b980ee3600           | mov                 ecx, 0x36ee80
            //   99                   | cdq                 
            //   f7f9                 | idiv                ecx
            //   b873b2e745           | mov                 eax, 0x45e7b273

        $sequence_8 = { 53 6a01 53 53 53 51 ff15???????? }
            // n = 7, score = 2000
            //   53                   | push                ebx
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_9 = { 8b442404 56 6a00 6a00 6a01 }
            // n = 5, score = 700
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   56                   | push                esi
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_10 = { 6a01 6a00 6a00 6800000040 50 ff15???????? 8bf0 }
            // n = 7, score = 700
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6800000040           | push                0x40000000
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_11 = { e8???????? 8a4c2404 6a01 884814 8b4c240c }
            // n = 5, score = 600
            //   e8????????           |                     
            //   8a4c2404             | mov                 cl, byte ptr [esp + 4]
            //   6a01                 | push                1
            //   884814               | mov                 byte ptr [eax + 0x14], cl
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]

        $sequence_12 = { 7423 8b542410 8b44240c 8d4c2408 6a00 51 }
            // n = 6, score = 600
            //   7423                 | je                  0x25
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   6a00                 | push                0
            //   51                   | push                ecx

        $sequence_13 = { 8b4c240c 898840200000 58 c20800 e9???????? }
            // n = 5, score = 600
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   898840200000         | mov                 dword ptr [eax + 0x2040], ecx
            //   58                   | pop                 eax
            //   c20800               | ret                 8
            //   e9????????           |                     

        $sequence_14 = { 50 56 ff15???????? 56 ff15???????? b001 }
            // n = 6, score = 600
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   b001                 | mov                 al, 1

        $sequence_15 = { 59 59 c3 8b65e8 ff7588 ff15???????? 833d????????ff }
            // n = 7, score = 600
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   8b65e8               | mov                 esp, dword ptr [ebp - 0x18]
            //   ff7588               | push                dword ptr [ebp - 0x78]
            //   ff15????????         |                     
            //   833d????????ff       |                     

        $sequence_16 = { ff15???????? 833d????????ff 750c ff742404 ff15???????? 59 c3 }
            // n = 7, score = 600
            //   ff15????????         |                     
            //   833d????????ff       |                     
            //   750c                 | jne                 0xe
            //   ff742404             | push                dword ptr [esp + 4]
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   c3                   | ret                 

        $sequence_17 = { ff15???????? 8bf0 83feff 7423 8b542410 }
            // n = 5, score = 600
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   83feff               | cmp                 esi, -1
            //   7423                 | je                  0x25
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]

        $sequence_18 = { f2ae f7d1 2bf9 6810270000 }
            // n = 4, score = 600
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   6810270000           | push                0x2710

        $sequence_19 = { ff742410 ff742410 ff742410 e8???????? c21000 e8???????? 8a4c2404 }
            // n = 7, score = 600
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   e8????????           |                     
            //   c21000               | ret                 0x10
            //   e8????????           |                     
            //   8a4c2404             | mov                 cl, byte ptr [esp + 4]

        $sequence_20 = { 8bf9 81e7ff000000 03f2 03f7 }
            // n = 4, score = 500
            //   8bf9                 | mov                 edi, ecx
            //   81e7ff000000         | and                 edi, 0xff
            //   03f2                 | add                 esi, edx
            //   03f7                 | add                 esi, edi

        $sequence_21 = { b8447c0000 e8???????? 53 56 57 }
            // n = 5, score = 500
            //   b8447c0000           | mov                 eax, 0x7c44
            //   e8????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_22 = { 6a00 680030c800 6a00 6a00 68???????? }
            // n = 5, score = 500
            //   6a00                 | push                0
            //   680030c800           | push                0xc83000
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_23 = { 8b542438 83c504 50 895500 }
            // n = 4, score = 500
            //   8b542438             | mov                 edx, dword ptr [esp + 0x38]
            //   83c504               | add                 ebp, 4
            //   50                   | push                eax
            //   895500               | mov                 dword ptr [ebp], edx

        $sequence_24 = { 8d442444 894d00 8b542438 83c504 }
            // n = 4, score = 500
            //   8d442444             | lea                 eax, [esp + 0x44]
            //   894d00               | mov                 dword ptr [ebp], ecx
            //   8b542438             | mov                 edx, dword ptr [esp + 0x38]
            //   83c504               | add                 ebp, 4

        $sequence_25 = { 6a00 6880000000 6800000400 8bce e8???????? }
            // n = 5, score = 500
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   6800000400           | push                0x40000
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_26 = { ffd6 8d44240c 6804010000 50 }
            // n = 4, score = 400
            //   ffd6                 | call                esi
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   6804010000           | push                0x104
            //   50                   | push                eax

        $sequence_27 = { 51 ff15???????? a1???????? b981000000 }
            // n = 4, score = 400
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   a1????????           |                     
            //   b981000000           | mov                 ecx, 0x81

        $sequence_28 = { 6a00 6a00 6a00 50 8bce e8???????? 6a00 }
            // n = 7, score = 400
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   6a00                 | push                0

        $sequence_29 = { 85c0 750c ff15???????? 53 }
            // n = 4, score = 400
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   ff15????????         |                     
            //   53                   | push                ebx

        $sequence_30 = { 7403 50 ffd6 b912010000 }
            // n = 4, score = 300
            //   7403                 | je                  5
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   b912010000           | mov                 ecx, 0x112

        $sequence_31 = { 56 57 b940000000 8d7c2411 88442410 f3ab }
            // n = 6, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   b940000000           | mov                 ecx, 0x40
            //   8d7c2411             | lea                 edi, [esp + 0x11]
            //   88442410             | mov                 byte ptr [esp + 0x10], al
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_32 = { ff15???????? 50 ff15???????? 68d0070000 ff15???????? }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   68d0070000           | push                0x7d0
            //   ff15????????         |                     

        $sequence_33 = { 8d4c2410 6804010000 51 aa ff15???????? }
            // n = 5, score = 300
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   6804010000           | push                0x104
            //   51                   | push                ecx
            //   aa                   | stosb               byte ptr es:[edi], al
            //   ff15????????         |                     

        $sequence_34 = { 3bc3 57 740b 8b35???????? 50 ffd6 }
            // n = 6, score = 300
            //   3bc3                 | cmp                 eax, ebx
            //   57                   | push                edi
            //   740b                 | je                  0xd
            //   8b35????????         |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_35 = { ffd6 eb06 8b35???????? a1???????? 3bc3 7403 50 }
            // n = 7, score = 300
            //   ffd6                 | call                esi
            //   eb06                 | jmp                 8
            //   8b35????????         |                     
            //   a1????????           |                     
            //   3bc3                 | cmp                 eax, ebx
            //   7403                 | je                  5
            //   50                   | push                eax

        $sequence_36 = { 83c414 e8???????? 6a00 6a00 8d542414 }
            // n = 5, score = 300
            //   83c414               | add                 esp, 0x14
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d542414             | lea                 edx, [esp + 0x14]

        $sequence_37 = { 6a00 8d542414 6a00 52 68???????? 6a00 }
            // n = 6, score = 300
            //   6a00                 | push                0
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   6a00                 | push                0
            //   52                   | push                edx
            //   68????????           |                     
            //   6a00                 | push                0

        $sequence_38 = { 68???????? 6801000080 ff15???????? 85c0 0f8599000000 53 56 }
            // n = 7, score = 300
            //   68????????           |                     
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8599000000         | jne                 0x9f
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_39 = { 33c0 8dbc245e020000 66899c245c020000 f3ab }
            // n = 4, score = 300
            //   33c0                 | xor                 eax, eax
            //   8dbc245e020000       | lea                 edi, [esp + 0x25e]
            //   66899c245c020000     | mov                 word ptr [esp + 0x25c], bx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_40 = { 56 68ff0f1f00 ff15???????? 85c0 740a 56 }
            // n = 6, score = 300
            //   56                   | push                esi
            //   68ff0f1f00           | push                0x1f0fff
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   56                   | push                esi

        $sequence_41 = { f3ab aa b9f9000000 33c0 }
            // n = 4, score = 300
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   b9f9000000           | mov                 ecx, 0xf9
            //   33c0                 | xor                 eax, eax

        $sequence_42 = { 5e 24fe 5b 40 81c408010000 c3 83c8ff }
            // n = 7, score = 300
            //   5e                   | pop                 esi
            //   24fe                 | and                 al, 0xfe
            //   5b                   | pop                 ebx
            //   40                   | inc                 eax
            //   81c408010000         | add                 esp, 0x108
            //   c3                   | ret                 
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_43 = { 83c41c 8d5c1850 83c520 41 81fb00200000 }
            // n = 5, score = 100
            //   83c41c               | add                 esp, 0x1c
            //   8d5c1850             | lea                 ebx, [eax + ebx + 0x50]
            //   83c520               | add                 ebp, 0x20
            //   41                   | inc                 ecx
            //   81fb00200000         | cmp                 ebx, 0x2000

        $sequence_44 = { 52 ff15???????? 85c0 8945dc }
            // n = 4, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax

        $sequence_45 = { e9???????? c745e0a08b4100 e9???????? c745e0a88b4100 e9???????? }
            // n = 5, score = 100
            //   e9????????           |                     
            //   c745e0a08b4100       | mov                 dword ptr [ebp - 0x20], 0x418ba0
            //   e9????????           |                     
            //   c745e0a88b4100       | mov                 dword ptr [ebp - 0x20], 0x418ba8
            //   e9????????           |                     

        $sequence_46 = { 8d8c24782c0000 50 51 e8???????? 83c41c 85c0 7443 }
            // n = 7, score = 100
            //   8d8c24782c0000       | lea                 ecx, [esp + 0x2c78]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   85c0                 | test                eax, eax
            //   7443                 | je                  0x45

        $sequence_47 = { 8a443b28 88443328 46 88543b28 81fe80000000 7ccb 8b4dfc }
            // n = 7, score = 100
            //   8a443b28             | mov                 al, byte ptr [ebx + edi + 0x28]
            //   88443328             | mov                 byte ptr [ebx + esi + 0x28], al
            //   46                   | inc                 esi
            //   88543b28             | mov                 byte ptr [ebx + edi + 0x28], dl
            //   81fe80000000         | cmp                 esi, 0x80
            //   7ccb                 | jl                  0xffffffcd
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_48 = { 68???????? 50 c745c8f4010000 ff15???????? 8b4dec 8bf0 51 }
            // n = 7, score = 100
            //   68????????           |                     
            //   50                   | push                eax
            //   c745c8f4010000       | mov                 dword ptr [ebp - 0x38], 0x1f4
            //   ff15????????         |                     
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   8bf0                 | mov                 esi, eax
            //   51                   | push                ecx

        $sequence_49 = { 57 8d1c8584bf4100 33c0 f00fb10b 8b15???????? 83cfff 8bca }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8d1c8584bf4100       | lea                 ebx, [eax*4 + 0x41bf84]
            //   33c0                 | xor                 eax, eax
            //   f00fb10b             | lock cmpxchg        dword ptr [ebx], ecx
            //   8b15????????         |                     
            //   83cfff               | or                  edi, 0xffffffff
            //   8bca                 | mov                 ecx, edx

        $sequence_50 = { c785e4edffff0c000000 c785e8edffff00000000 c785ecedffff01000000 ff15???????? 8d8580edffff 50 ff15???????? }
            // n = 7, score = 100
            //   c785e4edffff0c000000     | mov    dword ptr [ebp - 0x121c], 0xc
            //   c785e8edffff00000000     | mov    dword ptr [ebp - 0x1218], 0
            //   c785ecedffff01000000     | mov    dword ptr [ebp - 0x1214], 1
            //   ff15????????         |                     
            //   8d8580edffff         | lea                 eax, [ebp - 0x1280]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_51 = { 50 8d8424ac010000 50 51 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8d8424ac010000       | lea                 eax, [esp + 0x1ac]
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_52 = { 83e908 8d7608 660fd60f 8d7f08 8b048d144e4000 ffe0 f7c703000000 }
            // n = 7, score = 100
            //   83e908               | sub                 ecx, 8
            //   8d7608               | lea                 esi, [esi + 8]
            //   660fd60f             | movq                qword ptr [edi], xmm1
            //   8d7f08               | lea                 edi, [edi + 8]
            //   8b048d144e4000       | mov                 eax, dword ptr [ecx*4 + 0x404e14]
            //   ffe0                 | jmp                 eax
            //   f7c703000000         | test                edi, 3

    condition:
        7 of them and filesize < 263168
}