rule win_kpot_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kpot_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kpot_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0bce 0fb67007 0fb64006 c1e608 }
            // n = 4, score = 500
            //   0bce                 | or                  ecx, esi
            //   0fb67007             | movzx               esi, byte ptr [eax + 7]
            //   0fb64006             | movzx               eax, byte ptr [eax + 6]
            //   c1e608               | shl                 esi, 8

        $sequence_1 = { 8b4608 8b0e ff3481 ff15???????? 8b4608 8b4e04 }
            // n = 6, score = 500
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   ff3481               | push                dword ptr [ecx + eax*4]
            //   ff15????????         |                     
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]

        $sequence_2 = { d1e8 8bc8 81e100000007 8bd8 }
            // n = 4, score = 500
            //   d1e8                 | shr                 eax, 1
            //   8bc8                 | mov                 ecx, eax
            //   81e100000007         | and                 ecx, 0x7000000
            //   8bd8                 | mov                 ebx, eax

        $sequence_3 = { 8a02 3c2d 7506 33ff 47 42 eb07 }
            // n = 7, score = 500
            //   8a02                 | mov                 al, byte ptr [edx]
            //   3c2d                 | cmp                 al, 0x2d
            //   7506                 | jne                 8
            //   33ff                 | xor                 edi, edi
            //   47                   | inc                 edi
            //   42                   | inc                 edx
            //   eb07                 | jmp                 9

        $sequence_4 = { 59 8d4df8 51 ff75f8 }
            // n = 4, score = 500
            //   59                   | pop                 ecx
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_5 = { 57 8bf8 8b4518 0fb67005 }
            // n = 4, score = 500
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   0fb67005             | movzx               esi, byte ptr [eax + 5]

        $sequence_6 = { 0bd1 8bcf c1e11b d1ef }
            // n = 4, score = 500
            //   0bd1                 | or                  edx, ecx
            //   8bcf                 | mov                 ecx, edi
            //   c1e11b               | shl                 ecx, 0x1b
            //   d1ef                 | shr                 edi, 1

        $sequence_7 = { 8bd6 e8???????? c6043700 8bc7 5f }
            // n = 5, score = 500
            //   8bd6                 | mov                 edx, esi
            //   e8????????           |                     
            //   c6043700             | mov                 byte ptr [edi + esi], 0
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi

        $sequence_8 = { 8a07 84c0 7417 8a0c3a 47 3ac8 74f2 }
            // n = 7, score = 500
            //   8a07                 | mov                 al, byte ptr [edi]
            //   84c0                 | test                al, al
            //   7417                 | je                  0x19
            //   8a0c3a               | mov                 cl, byte ptr [edx + edi]
            //   47                   | inc                 edi
            //   3ac8                 | cmp                 cl, al
            //   74f2                 | je                  0xfffffff4

        $sequence_9 = { 53 56 57 8bf8 8b4518 0fb67005 }
            // n = 6, score = 500
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   0fb67005             | movzx               esi, byte ptr [eax + 5]

    condition:
        7 of them and filesize < 219136
}