rule win_krdownloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.krdownloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.krdownloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb26 8b4dfc 034df4 0fb6512c 52 68???????? 8b45f0 }
            // n = 7, score = 200
            //   eb26                 | jmp                 0x28
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   034df4               | add                 ecx, dword ptr [ebp - 0xc]
            //   0fb6512c             | movzx               edx, byte ptr [ecx + 0x2c]
            //   52                   | push                edx
            //   68????????           |                     
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_1 = { 83ec34 894df8 c745fc00000000 8b450c }
            // n = 4, score = 200
            //   83ec34               | sub                 esp, 0x34
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_2 = { c745ec00000000 c745f400000000 c745d810000000 c745e000000000 c745d000000000 c745f800000000 c745e800000000 }
            // n = 7, score = 200
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   c745d810000000       | mov                 dword ptr [ebp - 0x28], 0x10
            //   c745e000000000       | mov                 dword ptr [ebp - 0x20], 0
            //   c745d000000000       | mov                 dword ptr [ebp - 0x30], 0
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0

        $sequence_3 = { 83c40c 8b45f8 50 ff15???????? eb26 }
            // n = 5, score = 200
            //   83c40c               | add                 esp, 0xc
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   eb26                 | jmp                 0x28

        $sequence_4 = { c745fc00000000 6a00 6822020000 ff15???????? }
            // n = 4, score = 200
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   6a00                 | push                0
            //   6822020000           | push                0x222
            //   ff15????????         |                     

        $sequence_5 = { 6a00 6840004004 8d45f4 50 68???????? 68???????? }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   6840004004           | push                0x4400040
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     

        $sequence_6 = { 83c40c c745f400000000 8d85f4f7ffff 50 8b4dfc 81c1640d0300 }
            // n = 6, score = 200
            //   83c40c               | add                 esp, 0xc
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   8d85f4f7ffff         | lea                 eax, [ebp - 0x80c]
            //   50                   | push                eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   81c1640d0300         | add                 ecx, 0x30d64

        $sequence_7 = { ffd1 8b55fc 83ba540d030000 7415 8b45fc 8b88540d0300 51 }
            // n = 7, score = 200
            //   ffd1                 | call                ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   83ba540d030000       | cmp                 dword ptr [edx + 0x30d54], 0
            //   7415                 | je                  0x17
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b88540d0300         | mov                 ecx, dword ptr [eax + 0x30d54]
            //   51                   | push                ecx

        $sequence_8 = { c740040f000000 8b4dfc 51 8b55f8 52 8d85e4ebffff }
            // n = 6, score = 200
            //   c740040f000000       | mov                 dword ptr [eax + 4], 0xf
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   51                   | push                ecx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   52                   | push                edx
            //   8d85e4ebffff         | lea                 eax, [ebp - 0x141c]

        $sequence_9 = { 50 8d85f0fbffff 50 8b4df8 51 e8???????? }
            // n = 6, score = 200
            //   50                   | push                eax
            //   8d85f0fbffff         | lea                 eax, [ebp - 0x410]
            //   50                   | push                eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   51                   | push                ecx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 352256
}