rule win_kronos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kronos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kronos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 8bca e8???????? 8b4510 015f0c 8b4f0c 33d2 }
            // n = 7, score = 2800
            //   51                   | push                ecx
            //   8bca                 | mov                 ecx, edx
            //   e8????????           |                     
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   015f0c               | add                 dword ptr [edi + 0xc], ebx
            //   8b4f0c               | mov                 ecx, dword ptr [edi + 0xc]
            //   33d2                 | xor                 edx, edx

        $sequence_1 = { 8b4508 8b4d10 5f 5b c70000000000 }
            // n = 5, score = 2800
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   c70000000000         | mov                 dword ptr [eax], 0

        $sequence_2 = { e8???????? 83450810 83451010 ff4d0c 837d0c00 7fe2 }
            // n = 6, score = 2800
            //   e8????????           |                     
            //   83450810             | add                 dword ptr [ebp + 8], 0x10
            //   83451010             | add                 dword ptr [ebp + 0x10], 0x10
            //   ff4d0c               | dec                 dword ptr [ebp + 0xc]
            //   837d0c00             | cmp                 dword ptr [ebp + 0xc], 0
            //   7fe2                 | jg                  0xffffffe4

        $sequence_3 = { 8955f4 8975f8 bfff000000 3935???????? 754a c705????????01000000 53 }
            // n = 7, score = 2800
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   bfff000000           | mov                 edi, 0xff
            //   3935????????         |                     
            //   754a                 | jne                 0x4c
            //   c705????????01000000     |     
            //   53                   | push                ebx

        $sequence_4 = { 83c40c 837dfc02 724b 8b55f4 83c208 52 8d4de0 }
            // n = 7, score = 2800
            //   83c40c               | add                 esp, 0xc
            //   837dfc02             | cmp                 dword ptr [ebp - 4], 2
            //   724b                 | jb                  0x4d
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   83c208               | add                 edx, 8
            //   52                   | push                edx
            //   8d4de0               | lea                 ecx, [ebp - 0x20]

        $sequence_5 = { 57 56 56 8d8da0efffff }
            // n = 4, score = 2800
            //   57                   | push                edi
            //   56                   | push                esi
            //   56                   | push                esi
            //   8d8da0efffff         | lea                 ecx, [ebp - 0x1060]

        $sequence_6 = { 8945c8 3bc6 0f8406020000 bfd8010000 57 e8???????? }
            // n = 6, score = 2800
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   3bc6                 | cmp                 eax, esi
            //   0f8406020000         | je                  0x20c
            //   bfd8010000           | mov                 edi, 0x1d8
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_7 = { 53 ff15???????? 8b442418 5f 5e 5b 8be5 }
            // n = 7, score = 2800
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp

        $sequence_8 = { 50 8d45e8 50 ffd2 8b4804 8b7008 }
            // n = 6, score = 2800
            //   50                   | push                eax
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   ffd2                 | call                edx
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8b7008               | mov                 esi, dword ptr [eax + 8]

        $sequence_9 = { b84d5a0000 663901 0f857f010000 8b413c 03c1 813850450000 0f856e010000 }
            // n = 7, score = 2800
            //   b84d5a0000           | mov                 eax, 0x5a4d
            //   663901               | cmp                 word ptr [ecx], ax
            //   0f857f010000         | jne                 0x185
            //   8b413c               | mov                 eax, dword ptr [ecx + 0x3c]
            //   03c1                 | add                 eax, ecx
            //   813850450000         | cmp                 dword ptr [eax], 0x4550
            //   0f856e010000         | jne                 0x174

    condition:
        7 of them and filesize < 1302528
}