rule win_ktlv_door_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ktlv_door."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ktlv_door"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffc2 85d2 7d10 488d053ed25900 31db 31c9 e8???????? }
            // n = 7, score = 100
            //   ffc2                 | mov                 ebx, dword ptr [eax + 0x20]
            //   85d2                 | dec                 eax
            //   7d10                 | mov                 ecx, dword ptr [esp + 0x58]
            //   488d053ed25900       | dec                 eax
            //   31db                 | mov                 edi, dword ptr [esp + 0x60]
            //   31c9                 | dec                 eax
            //   e8????????           |                     

        $sequence_1 = { eb0e 488d3d1a475800 6690 e8???????? 488d0594b92c00 e8???????? 48c7400836000000 }
            // n = 7, score = 100
            //   eb0e                 | dec                 eax
            //   488d3d1a475800       | lea                 ecx, [0x1999ca]
            //   6690                 | dec                 eax
            //   e8????????           |                     
            //   488d0594b92c00       | mov                 dword ptr [eax], ecx
            //   e8????????           |                     
            //   48c7400836000000     | jne                 0xe11

        $sequence_2 = { eb25 488b8424a00c0000 4889c3 488d8c24780a0000 0f1f4000 e8???????? 488b542430 }
            // n = 7, score = 100
            //   eb25                 | lea                 esi, [0x2a1ba9]
            //   488b8424a00c0000     | dec                 eax
            //   4889c3               | mov                 ecx, eax
            //   488d8c24780a0000     | dec                 eax
            //   0f1f4000             | mov                 dword ptr [esp + 0x38], ecx
            //   e8????????           |                     
            //   488b542430           | dec                 eax

        $sequence_3 = { eb11 488d7818 488b8c2440080000 e8???????? 48c7400810000000 488d0da4e81900 488908 }
            // n = 7, score = 100
            //   eb11                 | mov                 eax, dword ptr [eax + 0x10]
            //   488d7818             | dec                 esp
            //   488b8c2440080000     | mov                 ecx, dword ptr [eax + 0x28]
            //   e8????????           |                     
            //   48c7400810000000     | nop                 dword ptr [eax]
            //   488d0da4e81900       | dec                 esp
            //   488908               | cmp                 edx, ecx

        $sequence_4 = { ffd0 488bac24c8010000 4881c4d0010000 c3 48899c2450020000 48898c2458020000 c644243700 }
            // n = 7, score = 100
            //   ffd0                 | mov                 ebx, dword ptr [ecx + 0x20]
            //   488bac24c8010000     | dec                 eax
            //   4881c4d0010000       | shl                 ebx, 0xd
            //   c3                   | dec                 eax
            //   48899c2450020000     | sub                 ebx, edx
            //   48898c2458020000     | dec                 eax
            //   c644243700           | mov                 edx, dword ptr [esp + 0x38]

        $sequence_5 = { eb0c 488d3d9bba4000 e8???????? 488b0d???????? 48898c2458050000 488d05800f1700 e8???????? }
            // n = 7, score = 100
            //   eb0c                 | dec                 eax
            //   488d3d9bba4000       | lea                 eax, [0x40efc9]
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   48898c2458050000     | mov                 ebx, 0x1f
            //   488d05800f1700       | nop                 
            //   e8????????           |                     

        $sequence_6 = { eb0d 488bbc24a8000000 e8???????? 4889c6 4889d9 488b842490000000 488b5c2460 }
            // n = 7, score = 100
            //   eb0d                 | lea                 edx, [0x14fb74]
            //   488bbc24a8000000     | dec                 eax
            //   e8????????           |                     
            //   4889c6               | mov                 ecx, dword ptr [esp + 0x58]
            //   4889d9               | dec                 eax
            //   488b842490000000     | mov                 edi, dword ptr [esp + 0x70]
            //   488b5c2460           | dec                 eax

        $sequence_7 = { eb0e 488d7818 488b4c2418 e8???????? 4889c3 488d05371d3d00 488b6c2428 }
            // n = 7, score = 100
            //   eb0e                 | mov                 edx, dword ptr [esp + 0x30]
            //   488d7818             | dec                 eax
            //   488b4c2418           | cmp                 eax, -1
            //   e8????????           |                     
            //   4889c3               | je                  0x181f
            //   488d05371d3d00       | dec                 eax
            //   488b6c2428           | cmp                 edx, eax

        $sequence_8 = { eb11 488d7838 488b8c24e8010000 e8???????? 488d0d529c2900 4889c2 4889842400010000 }
            // n = 7, score = 100
            //   eb11                 | dec                 eax
            //   488d7838             | mov                 edi, eax
            //   488b8c24e8010000     | dec                 eax
            //   e8????????           |                     
            //   488d0d529c2900       | mov                 esi, ebx
            //   4889c2               | xor                 eax, eax
            //   4889842400010000     | dec                 eax

        $sequence_9 = { e8???????? 440f11bc24e0010000 440f11bc24f0010000 488b8c24e0000000 48898c24e0010000 488b8c24c8010000 48898c24e8010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   440f11bc24e0010000     | mov    byte ptr [eax + edx], 0x65
            //   440f11bc24f0010000     | dec    eax
            //   488b8c24e0000000     | mov                 edi, ecx
            //   48898c24e0010000     | dec                 eax
            //   488b8c24c8010000     | lea                 eax, [0xbaf20]
            //   48898c24e8010000     | dec                 eax

    condition:
        7 of them and filesize < 14630912
}