rule win_kuaibu8_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kuaibu8."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kuaibu8"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff35???????? b902000000 e8???????? 83c408 8945e0 8b45e0 50 }
            // n = 7, score = 100
            //   ff35????????         |                     
            //   b902000000           | mov                 ecx, 2
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   50                   | push                eax

        $sequence_1 = { 83c404 c1e002 03d8 895db4 8b5de8 e8???????? b804000000 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   c1e002               | shl                 eax, 2
            //   03d8                 | add                 ebx, eax
            //   895db4               | mov                 dword ptr [ebp - 0x4c], ebx
            //   8b5de8               | mov                 ebx, dword ptr [ebp - 0x18]
            //   e8????????           |                     
            //   b804000000           | mov                 eax, 4

        $sequence_2 = { 6a10 52 56 6689442416 e8???????? }
            // n = 5, score = 100
            //   6a10                 | push                0x10
            //   52                   | push                edx
            //   56                   | push                esi
            //   6689442416           | mov                 word ptr [esp + 0x16], ax
            //   e8????????           |                     

        $sequence_3 = { 7409 53 e8???????? 83c404 8b5de8 e8???????? }
            // n = 6, score = 100
            //   7409                 | je                  0xb
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b5de8               | mov                 ebx, dword ptr [ebp - 0x18]
            //   e8????????           |                     

        $sequence_4 = { 895dbc e8???????? 894db8 8b7dbc c70701000000 83c704 8bc1 }
            // n = 7, score = 100
            //   895dbc               | mov                 dword ptr [ebp - 0x44], ebx
            //   e8????????           |                     
            //   894db8               | mov                 dword ptr [ebp - 0x48], ecx
            //   8b7dbc               | mov                 edi, dword ptr [ebp - 0x44]
            //   c70701000000         | mov                 dword ptr [edi], 1
            //   83c704               | add                 edi, 4
            //   8bc1                 | mov                 eax, ecx

        $sequence_5 = { 83c404 58 8945f4 8965ec 8d45f0 50 8b45f4 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   58                   | pop                 eax
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8965ec               | mov                 dword ptr [ebp - 0x14], esp
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_6 = { 83f800 0f851e000000 b8???????? 50 8b5d10 8b1b }
            // n = 6, score = 100
            //   83f800               | cmp                 eax, 0
            //   0f851e000000         | jne                 0x24
            //   b8????????           |                     
            //   50                   | push                eax
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   8b1b                 | mov                 ebx, dword ptr [ebx]

        $sequence_7 = { b8???????? 8945d8 8d45d8 50 6800000000 ff35???????? 8d45e0 }
            // n = 7, score = 100
            //   b8????????           |                     
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   6800000000           | push                0
            //   ff35????????         |                     
            //   8d45e0               | lea                 eax, [ebp - 0x20]

        $sequence_8 = { 837d1400 0f8507000000 c7451401000000 837d1000 0f85aa020000 6802000080 6a00 }
            // n = 7, score = 100
            //   837d1400             | cmp                 dword ptr [ebp + 0x14], 0
            //   0f8507000000         | jne                 0xd
            //   c7451401000000       | mov                 dword ptr [ebp + 0x14], 1
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   0f85aa020000         | jne                 0x2b0
            //   6802000080           | push                0x80000002
            //   6a00                 | push                0

        $sequence_9 = { 53 55 56 8b742430 85f6 57 750a }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   56                   | push                esi
            //   8b742430             | mov                 esi, dword ptr [esp + 0x30]
            //   85f6                 | test                esi, esi
            //   57                   | push                edi
            //   750a                 | jne                 0xc

    condition:
        7 of them and filesize < 737280
}