rule win_kugelblitz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kugelblitz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kugelblitz"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 448bc0 83f8ff 0f8405010000 0f1f440000 488b4de8 }
            // n = 5, score = 100
            //   448bc0               | add                 ecx, eax
            //   83f8ff               | mov                 edx, 2
            //   0f8405010000         | nop                 
            //   0f1f440000           | dec                 eax
            //   488b4de8             | mov                 eax, edi

        $sequence_1 = { c3 488d0511430000 c3 488d0501430000 c3 }
            // n = 5, score = 100
            //   c3                   | mov                 ecx, dword ptr [ecx - 8]
            //   488d0511430000       | dec                 eax
            //   c3                   | sub                 eax, ecx
            //   488d0501430000       | dec                 eax
            //   c3                   | add                 eax, -8

        $sequence_2 = { 4053 4883ec20 488bd9 488d0580230000 488901 }
            // n = 5, score = 100
            //   4053                 | lea                 eax, [0x2ff7]
            //   4883ec20             | nop                 
            //   488bd9               | dec                 eax
            //   488d0580230000       | mov                 eax, dword ptr [edi]
            //   488901               | dec                 eax

        $sequence_3 = { 4883c227 488b49f8 482bc1 4883c0f8 4883f81f 7669 }
            // n = 6, score = 100
            //   4883c227             | xor                 eax, eax
            //   488b49f8             | dec                 eax
            //   482bc1               | lea                 ecx, [esp + 0x70]
            //   4883c0f8             | dec                 eax
            //   4883f81f             | lea                 edx, [esp + 0x40]
            //   7669                 | dec                 eax

        $sequence_4 = { 483bd3 0f8727010000 48896c2430 4883ca07 488b6918 }
            // n = 5, score = 100
            //   483bd3               | je                  0x359
            //   0f8727010000         | dec                 eax
            //   48896c2430           | lea                 ebx, [eax + 0x27]
            //   4883ca07             | dec                 eax
            //   488b6918             | test                eax, eax

        $sequence_5 = { 488d542448 488d4c2470 480f47542448 e8???????? 488b442470 }
            // n = 5, score = 100
            //   488d542448           | jne                 0x310
            //   488d4c2470           | dec                 eax
            //   480f47542448         | sub                 esp, 0x20
            //   e8????????           |                     
            //   488b442470           | dec                 eax

        $sequence_6 = { 488d0da2410000 e8???????? 85c0 742e 32c0 eb33 }
            // n = 6, score = 100
            //   488d0da2410000       | mov                 edi, 1
            //   e8????????           |                     
            //   85c0                 | jmp                 0x919
            //   742e                 | dec                 eax
            //   32c0                 | lea                 ecx, [ebp - 0x80]
            //   eb33                 | int3                

        $sequence_7 = { 33db eb49 4881f900100000 7238 }
            // n = 4, score = 100
            //   33db                 | dec                 eax
            //   eb49                 | or                  edx, 7
            //   4881f900100000       | dec                 eax
            //   7238                 | mov                 ebp, dword ptr [ecx + 0x18]

        $sequence_8 = { 4a8d1409 e8???????? 48895de8 488b8f80000000 ff15???????? }
            // n = 5, score = 100
            //   4a8d1409             | lea                 eax, [0x30c9]
            //   e8????????           |                     
            //   48895de8             | dec                 eax
            //   488b8f80000000       | sub                 esp, 0x20
            //   ff15????????         |                     

        $sequence_9 = { 488b442470 4533c0 ba02000000 48634804 488d442470 }
            // n = 5, score = 100
            //   488b442470           | inc                 ecx
            //   4533c0               | mov                 eax, 0x110
            //   ba02000000           | dec                 eax
            //   48634804             | lea                 ecx, [esp + 0x70]
            //   488d442470           | xor                 edx, edx

    condition:
        7 of them and filesize < 82944
}