rule win_kuluoz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kuluoz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kuluoz"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4de8 83790c00 0f84e3000000 8b55e8 }
            // n = 4, score = 100
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   83790c00             | cmp                 dword ptr [ecx + 0xc], 0
            //   0f84e3000000         | je                  0xe9
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]

        $sequence_1 = { 8bff 55 8bec 51 8b4508 8945fc 8b4d0c }
            // n = 7, score = 100
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]

        $sequence_2 = { 8b8da0fbffff 898df0fbffff 8b95a4fbffff 8995f4fbffff eb6f 8d85f8fbffff 50 }
            // n = 7, score = 100
            //   8b8da0fbffff         | mov                 ecx, dword ptr [ebp - 0x460]
            //   898df0fbffff         | mov                 dword ptr [ebp - 0x410], ecx
            //   8b95a4fbffff         | mov                 edx, dword ptr [ebp - 0x45c]
            //   8995f4fbffff         | mov                 dword ptr [ebp - 0x40c], edx
            //   eb6f                 | jmp                 0x71
            //   8d85f8fbffff         | lea                 eax, [ebp - 0x408]
            //   50                   | push                eax

        $sequence_3 = { 85c0 740b 8b4df0 83c101 894df0 ebd7 8b55f0 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   740b                 | je                  0xd
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   83c101               | add                 ecx, 1
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   ebd7                 | jmp                 0xffffffd9
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]

        $sequence_4 = { 8bff 55 8bec 51 56 c745fc00000000 eb09 }
            // n = 7, score = 100
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   56                   | push                esi
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   eb09                 | jmp                 0xb

        $sequence_5 = { e8???????? 8b08 898d5cfbffff 8b5004 899560fbffff 8b4008 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   898d5cfbffff         | mov                 dword ptr [ebp - 0x4a4], ecx
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   899560fbffff         | mov                 dword ptr [ebp - 0x4a0], edx
            //   8b4008               | mov                 eax, dword ptr [eax + 8]

        $sequence_6 = { 8b4508 054a050000 8b4d08 3b814a2d0000 7504 b001 eb02 }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   054a050000           | add                 eax, 0x54a
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   3b814a2d0000         | cmp                 eax, dword ptr [ecx + 0x2d4a]
            //   7504                 | jne                 6
            //   b001                 | mov                 al, 1
            //   eb02                 | jmp                 4

        $sequence_7 = { 50 e8???????? 8945f4 837df4ff 7405 8b45f4 eb4b }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   837df4ff             | cmp                 dword ptr [ebp - 0xc], -1
            //   7405                 | je                  7
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   eb4b                 | jmp                 0x4d

        $sequence_8 = { 0fbe5508 83fa0a 7409 0fbe4508 83f80d 7504 b001 }
            // n = 7, score = 100
            //   0fbe5508             | movsx               edx, byte ptr [ebp + 8]
            //   83fa0a               | cmp                 edx, 0xa
            //   7409                 | je                  0xb
            //   0fbe4508             | movsx               eax, byte ptr [ebp + 8]
            //   83f80d               | cmp                 eax, 0xd
            //   7504                 | jne                 6
            //   b001                 | mov                 al, 1

        $sequence_9 = { 8955f0 8b45f0 3b45e0 734e }
            // n = 4, score = 100
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   3b45e0               | cmp                 eax, dword ptr [ebp - 0x20]
            //   734e                 | jae                 0x50

    condition:
        7 of them and filesize < 65536
}