rule win_kutaki_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kutaki."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kutaki"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8945d4 8d55d4 52 8d45cc 50 ff15???????? }
            // n = 7, score = 700
            //   e8????????           |                     
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8d55d4               | lea                 edx, [ebp - 0x2c]
            //   52                   | push                edx
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_1 = { ff15???????? 85c0 0f849b020000 8d4ddc 51 ff15???????? 50 }
            // n = 7, score = 700
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f849b020000         | je                  0x2a1
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_2 = { 51 e8???????? c745fc04000000 8b5510 33db 833a00 0f9ec3 }
            // n = 7, score = 700
            //   51                   | push                ecx
            //   e8????????           |                     
            //   c745fc04000000       | mov                 dword ptr [ebp - 4], 4
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   33db                 | xor                 ebx, ebx
            //   833a00               | cmp                 dword ptr [edx], 0
            //   0f9ec3               | setle               bl

        $sequence_3 = { 8b4db4 3b4810 7309 c7458800000000 eb09 ff15???????? }
            // n = 6, score = 700
            //   8b4db4               | mov                 ecx, dword ptr [ebp - 0x4c]
            //   3b4810               | cmp                 ecx, dword ptr [eax + 0x10]
            //   7309                 | jae                 0xb
            //   c7458800000000       | mov                 dword ptr [ebp - 0x78], 0
            //   eb09                 | jmp                 0xb
            //   ff15????????         |                     

        $sequence_4 = { 8d953cffffff 52 6808200000 ff15???????? 898564feffff 8d8564feffff 50 }
            // n = 7, score = 700
            //   8d953cffffff         | lea                 edx, [ebp - 0xc4]
            //   52                   | push                edx
            //   6808200000           | push                0x2008
            //   ff15????????         |                     
            //   898564feffff         | mov                 dword ptr [ebp - 0x19c], eax
            //   8d8564feffff         | lea                 eax, [ebp - 0x19c]
            //   50                   | push                eax

        $sequence_5 = { ffd7 a1???????? 6685f6 0f8dfd000000 85c0 7515 68???????? }
            // n = 7, score = 700
            //   ffd7                 | call                edi
            //   a1????????           |                     
            //   6685f6               | test                si, si
            //   0f8dfd000000         | jge                 0x103
            //   85c0                 | test                eax, eax
            //   7515                 | jne                 0x17
            //   68????????           |                     

        $sequence_6 = { 50 ff15???????? 898548ffffff eb0a c78548ffffff00000000 833d????????00 751c }
            // n = 7, score = 700
            //   50                   | push                eax
            //   ff15????????         |                     
            //   898548ffffff         | mov                 dword ptr [ebp - 0xb8], eax
            //   eb0a                 | jmp                 0xc
            //   c78548ffffff00000000     | mov    dword ptr [ebp - 0xb8], 0
            //   833d????????00       |                     
            //   751c                 | jne                 0x1e

        $sequence_7 = { 68???????? c78570ffffff01000000 c78568ffffff02000000 ffd6 68???????? 66898560ffffff c78558ffffff02000000 }
            // n = 7, score = 700
            //   68????????           |                     
            //   c78570ffffff01000000     | mov    dword ptr [ebp - 0x90], 1
            //   c78568ffffff02000000     | mov    dword ptr [ebp - 0x98], 2
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   66898560ffffff       | mov                 word ptr [ebp - 0xa0], ax
            //   c78558ffffff02000000     | mov    dword ptr [ebp - 0xa8], 2

        $sequence_8 = { 8985a4feffff 83bda4feffff00 7d26 68a0000000 }
            // n = 4, score = 700
            //   8985a4feffff         | mov                 dword ptr [ebp - 0x15c], eax
            //   83bda4feffff00       | cmp                 dword ptr [ebp - 0x15c], 0
            //   7d26                 | jge                 0x28
            //   68a0000000           | push                0xa0

        $sequence_9 = { 8b957cffffff 52 ff15???????? 898518ffffff eb0a c78518ffffff00000000 8b45c8 }
            // n = 7, score = 700
            //   8b957cffffff         | mov                 edx, dword ptr [ebp - 0x84]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   898518ffffff         | mov                 dword ptr [ebp - 0xe8], eax
            //   eb0a                 | jmp                 0xc
            //   c78518ffffff00000000     | mov    dword ptr [ebp - 0xe8], 0
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]

    condition:
        7 of them and filesize < 1335296
}