rule win_kwampirs_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kwampirs."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kwampirs"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 391f 0f95c0 8b4df0 64890d00000000 59 5f 5e }
            // n = 7, score = 800
            //   391f                 | cmp                 dword ptr [edi], ebx
            //   0f95c0               | setne               al
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_1 = { 83c418 85c0 7512 8b07 50 e8???????? 83c404 }
            // n = 7, score = 800
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax
            //   7512                 | jne                 0x14
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_2 = { 391f 0f95c0 8b4df0 64890d00000000 }
            // n = 4, score = 800
            //   391f                 | cmp                 dword ptr [edi], ebx
            //   0f95c0               | setne               al
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx

        $sequence_3 = { 52 50 8d8dbcf3ffff 51 }
            // n = 4, score = 800
            //   52                   | push                edx
            //   50                   | push                eax
            //   8d8dbcf3ffff         | lea                 ecx, [ebp - 0xc44]
            //   51                   | push                ecx

        $sequence_4 = { 33d2 668955f6 e8???????? 83c40c }
            // n = 4, score = 800
            //   33d2                 | xor                 edx, edx
            //   668955f6             | mov                 word ptr [ebp - 0xa], dx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_5 = { ffd6 8b45c0 50 ffd6 }
            // n = 4, score = 800
            //   ffd6                 | call                esi
            //   8b45c0               | mov                 eax, dword ptr [ebp - 0x40]
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_6 = { 50 ffd6 8b4dc4 51 ffd6 }
            // n = 5, score = 800
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8b4dc4               | mov                 ecx, dword ptr [ebp - 0x3c]
            //   51                   | push                ecx
            //   ffd6                 | call                esi

        $sequence_7 = { 668955f6 e8???????? 83c40c 33d2 }
            // n = 4, score = 800
            //   668955f6             | mov                 word ptr [ebp - 0xa], dx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   33d2                 | xor                 edx, edx

        $sequence_8 = { c745fcfeffffff e8???????? b001 8b4df0 }
            // n = 4, score = 800
            //   c745fcfeffffff       | mov                 dword ptr [ebp - 4], 0xfffffffe
            //   e8????????           |                     
            //   b001                 | mov                 al, 1
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_9 = { 33d2 6816060000 52 8d85bef3ffff 50 }
            // n = 5, score = 800
            //   33d2                 | xor                 edx, edx
            //   6816060000           | push                0x616
            //   52                   | push                edx
            //   8d85bef3ffff         | lea                 eax, [ebp - 0xc42]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 2695168
}