rule win_lambert_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lambert."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lambert"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4f 42 3b7d10 724d }
            // n = 4, score = 300
            //   4f                   | dec                 edi
            //   42                   | inc                 edx
            //   3b7d10               | cmp                 edi, dword ptr [ebp + 0x10]
            //   724d                 | jb                  0x4f

        $sequence_1 = { 8b4d08 03481c 894de4 8b55f4 8b45e4 }
            // n = 5, score = 300
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   03481c               | add                 ecx, dword ptr [eax + 0x1c]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_2 = { 33ce 314de8 890a 894de4 }
            // n = 4, score = 300
            //   33ce                 | xor                 ecx, esi
            //   314de8               | xor                 dword ptr [ebp - 0x18], ecx
            //   890a                 | mov                 dword ptr [edx], ecx
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx

        $sequence_3 = { 7402 eb60 8b45fc 83c078 8945f0 8b4df0 }
            // n = 6, score = 300
            //   7402                 | je                  4
            //   eb60                 | jmp                 0x62
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c078               | add                 eax, 0x78
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_4 = { 85c0 741f 8b4df8 c1e90d 8b55f8 c1e213 0bca }
            // n = 7, score = 300
            //   85c0                 | test                eax, eax
            //   741f                 | je                  0x21
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   c1e90d               | shr                 ecx, 0xd
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   c1e213               | shl                 edx, 0x13
            //   0bca                 | or                  ecx, edx

        $sequence_5 = { 41 8801 41 e9???????? 6afc 2b4d10 8b5514 }
            // n = 7, score = 300
            //   41                   | inc                 ecx
            //   8801                 | mov                 byte ptr [ecx], al
            //   41                   | inc                 ecx
            //   e9????????           |                     
            //   6afc                 | push                -4
            //   2b4d10               | sub                 ecx, dword ptr [ebp + 0x10]
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]

        $sequence_6 = { 0f82a4000000 83fe06 0f822cffffff 8bc1 }
            // n = 4, score = 300
            //   0f82a4000000         | jb                  0xaa
            //   83fe06               | cmp                 esi, 6
            //   0f822cffffff         | jb                  0xffffff32
            //   8bc1                 | mov                 eax, ecx

        $sequence_7 = { 33ce 33d1 33da 8970f0 }
            // n = 4, score = 300
            //   33ce                 | xor                 ecx, esi
            //   33d1                 | xor                 edx, ecx
            //   33da                 | xor                 ebx, edx
            //   8970f0               | mov                 dword ptr [eax - 0x10], esi

        $sequence_8 = { 51 e8???????? 0fb7d0 0355f8 }
            // n = 4, score = 300
            //   51                   | push                ecx
            //   e8????????           |                     
            //   0fb7d0               | movzx               edx, ax
            //   0355f8               | add                 edx, dword ptr [ebp - 8]

        $sequence_9 = { 0bca 894df8 8b45fc 0fb708 51 e8???????? }
            // n = 6, score = 300
            //   0bca                 | or                  ecx, edx
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   0fb708               | movzx               ecx, word ptr [eax]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_10 = { 33c1 03c0 33c8 8bc1 c1e808 }
            // n = 5, score = 300
            //   33c1                 | xor                 eax, ecx
            //   03c0                 | add                 eax, eax
            //   33c8                 | xor                 ecx, eax
            //   8bc1                 | mov                 eax, ecx
            //   c1e808               | shr                 eax, 8

        $sequence_11 = { 8945fc 8b4d0c 8b55fc 3b5118 }
            // n = 4, score = 300
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   3b5118               | cmp                 edx, dword ptr [ecx + 0x18]

        $sequence_12 = { 2bc2 83f801 0f8208010000 803a00 }
            // n = 4, score = 300
            //   2bc2                 | sub                 eax, edx
            //   83f801               | cmp                 eax, 1
            //   0f8208010000         | jb                  0x10e
            //   803a00               | cmp                 byte ptr [edx], 0

        $sequence_13 = { 4f 42 42 eb56 }
            // n = 4, score = 300
            //   4f                   | dec                 edi
            //   42                   | inc                 edx
            //   42                   | inc                 edx
            //   eb56                 | jmp                 0x58

        $sequence_14 = { 8b5508 031481 8955f4 8b45f4 50 e8???????? }
            // n = 6, score = 300
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   031481               | add                 edx, dword ptr [ecx + eax*4]
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_15 = { f7d2 8b45f4 335004 8955f8 8b4df4 }
            // n = 5, score = 300
            //   f7d2                 | not                 edx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   335004               | xor                 edx, dword ptr [eax + 4]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

    condition:
        7 of them and filesize < 1205248
}