rule win_lambload_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lambload."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lambload"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 6a02 8bf9 c785c0fbffff04010000 ff15???????? }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   8bf9                 | mov                 edi, ecx
            //   c785c0fbffff04010000     | mov    dword ptr [ebp - 0x440], 0x104
            //   ff15????????         |                     

        $sequence_1 = { f3a4 ffb5c4fbffff ff15???????? 8d7bfe }
            // n = 4, score = 100
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   ffb5c4fbffff         | push                dword ptr [ebp - 0x43c]
            //   ff15????????         |                     
            //   8d7bfe               | lea                 edi, [ebx - 2]

        $sequence_2 = { 0f8468ffffff 8d85f4fdffff 50 e8???????? }
            // n = 4, score = 100
            //   0f8468ffffff         | je                  0xffffff6e
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { c70009000000 ebc5 8bc3 c1f805 8d3c8500490710 8bf3 83e61f }
            // n = 7, score = 100
            //   c70009000000         | mov                 dword ptr [eax], 9
            //   ebc5                 | jmp                 0xffffffc7
            //   8bc3                 | mov                 eax, ebx
            //   c1f805               | sar                 eax, 5
            //   8d3c8500490710       | lea                 edi, [eax*4 + 0x10074900]
            //   8bf3                 | mov                 esi, ebx
            //   83e61f               | and                 esi, 0x1f

        $sequence_4 = { 8a00 88443dfc 8a5dfd 47 ff4508 }
            // n = 5, score = 100
            //   8a00                 | mov                 al, byte ptr [eax]
            //   88443dfc             | mov                 byte ptr [ebp + edi - 4], al
            //   8a5dfd               | mov                 bl, byte ptr [ebp - 3]
            //   47                   | inc                 edi
            //   ff4508               | inc                 dword ptr [ebp + 8]

        $sequence_5 = { 33c9 3bc7 0f95c1 894604 8d41ff 8b4dfc 5f }
            // n = 7, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   3bc7                 | cmp                 eax, edi
            //   0f95c1               | setne               cl
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   8d41ff               | lea                 eax, [ecx - 1]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   5f                   | pop                 edi

        $sequence_6 = { 394510 7241 6a04 5b 7705 }
            // n = 5, score = 100
            //   394510               | cmp                 dword ptr [ebp + 0x10], eax
            //   7241                 | jb                  0x43
            //   6a04                 | push                4
            //   5b                   | pop                 ebx
            //   7705                 | ja                  7

        $sequence_7 = { 59 8945e0 85c0 7461 8d0cbd00490710 }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   85c0                 | test                eax, eax
            //   7461                 | je                  0x63
            //   8d0cbd00490710       | lea                 ecx, [edi*4 + 0x10074900]

        $sequence_8 = { 8bff 56 57 33ff ffb7602b0710 }
            // n = 5, score = 100
            //   8bff                 | mov                 edi, edi
            //   56                   | push                esi
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   ffb7602b0710         | push                dword ptr [edi + 0x10072b60]

        $sequence_9 = { 6685c9 75f4 8b4dfc 8bfb 8bf0 }
            // n = 5, score = 100
            //   6685c9               | test                cx, cx
            //   75f4                 | jne                 0xfffffff6
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8bfb                 | mov                 edi, ebx
            //   8bf0                 | mov                 esi, eax

    condition:
        7 of them and filesize < 1039360
}