rule win_laplas_shell_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.laplas_shell."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.laplas_shell"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb6825c324000 308618504000 8b4f10 8b5f14 0fb69618504000 3bcb }
            // n = 6, score = 100
            //   0fb6825c324000       | movzx               eax, byte ptr [edx + 0x40325c]
            //   308618504000         | xor                 byte ptr [esi + 0x405018], al
            //   8b4f10               | mov                 ecx, dword ptr [edi + 0x10]
            //   8b5f14               | mov                 ebx, dword ptr [edi + 0x14]
            //   0fb69618504000       | movzx               edx, byte ptr [esi + 0x405018]
            //   3bcb                 | cmp                 ecx, ebx

        $sequence_1 = { f7f1 0fb6825c324000 308618504000 8b4f10 8b5f14 0fb69618504000 3bcb }
            // n = 7, score = 100
            //   f7f1                 | div                 ecx
            //   0fb6825c324000       | movzx               eax, byte ptr [edx + 0x40325c]
            //   308618504000         | xor                 byte ptr [esi + 0x405018], al
            //   8b4f10               | mov                 ecx, dword ptr [edi + 0x10]
            //   8b5f14               | mov                 ebx, dword ptr [edi + 0x14]
            //   0fb69618504000       | movzx               edx, byte ptr [esi + 0x405018]
            //   3bcb                 | cmp                 ecx, ebx

        $sequence_2 = { 8bc8 85c9 7504 ffd3 }
            // n = 4, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   85c9                 | test                ecx, ecx
            //   7504                 | jne                 6
            //   ffd3                 | call                ebx

        $sequence_3 = { c745fcffffffff 8b95ecfbffff 8b1d???????? 8b3d???????? }
            // n = 4, score = 100
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8b95ecfbffff         | mov                 edx, dword ptr [ebp - 0x414]
            //   8b1d????????         |                     
            //   8b3d????????         |                     

        $sequence_4 = { 89b594e6ffff 89b590e6ffff ff15???????? 85c0 7555 56 }
            // n = 6, score = 100
            //   89b594e6ffff         | mov                 dword ptr [ebp - 0x196c], esi
            //   89b590e6ffff         | mov                 dword ptr [ebp - 0x1970], esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7555                 | jne                 0x57
            //   56                   | push                esi

        $sequence_5 = { 55 8bec 6aff 68???????? 64a100000000 50 b8ac190000 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   6aff                 | push                -1
            //   68????????           |                     
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   50                   | push                eax
            //   b8ac190000           | mov                 eax, 0x19ac

        $sequence_6 = { 668985cafbffff 8d85c8fbffff 6a10 50 }
            // n = 4, score = 100
            //   668985cafbffff       | mov                 word ptr [ebp - 0x436], ax
            //   8d85c8fbffff         | lea                 eax, [ebp - 0x438]
            //   6a10                 | push                0x10
            //   50                   | push                eax

        $sequence_7 = { 0f57c0 c78558e6ffff44000000 6a00 50 }
            // n = 4, score = 100
            //   0f57c0               | xorps               xmm0, xmm0
            //   c78558e6ffff44000000     | mov    dword ptr [ebp - 0x19a8], 0x44
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_8 = { ba???????? 50 8b0d???????? e8???????? }
            // n = 4, score = 100
            //   ba????????           |                     
            //   50                   | push                eax
            //   8b0d????????         |                     
            //   e8????????           |                     

        $sequence_9 = { c745fc00000000 83bdecfbffff08 8d85d8fbffff 51 0f4385d8fbffff 8d8d58e6ffff }
            // n = 6, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   83bdecfbffff08       | cmp                 dword ptr [ebp - 0x414], 8
            //   8d85d8fbffff         | lea                 eax, [ebp - 0x428]
            //   51                   | push                ecx
            //   0f4385d8fbffff       | cmovae              eax, dword ptr [ebp - 0x428]
            //   8d8d58e6ffff         | lea                 ecx, [ebp - 0x19a8]

    condition:
        7 of them and filesize < 59392
}