rule win_latentbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.latentbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.latentbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5f c3 55 8bec 8b4604 81ecdc020000 85c0 }
            // n = 7, score = 100
            //   5f                   | pop                 edi
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   81ecdc020000         | sub                 esp, 0x2dc
            //   85c0                 | test                eax, eax

        $sequence_1 = { 7505 be04000000 56 6800300000 8d44241c 50 6a00 }
            // n = 7, score = 100
            //   7505                 | jne                 7
            //   be04000000           | mov                 esi, 4
            //   56                   | push                esi
            //   6800300000           | push                0x3000
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_2 = { 8d4c2410 51 6aff ffd2 33c0 8703 }
            // n = 6, score = 100
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   51                   | push                ecx
            //   6aff                 | push                -1
            //   ffd2                 | call                edx
            //   33c0                 | xor                 eax, eax
            //   8703                 | xchg                dword ptr [ebx], eax

        $sequence_3 = { 8bc3 e8???????? 299ff42a0000 015e0c 295e10 015e14 8b87f42a0000 }
            // n = 7, score = 100
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   299ff42a0000         | sub                 dword ptr [edi + 0x2af4], ebx
            //   015e0c               | add                 dword ptr [esi + 0xc], ebx
            //   295e10               | sub                 dword ptr [esi + 0x10], ebx
            //   015e14               | add                 dword ptr [esi + 0x14], ebx
            //   8b87f42a0000         | mov                 eax, dword ptr [edi + 0x2af4]

        $sequence_4 = { ff5554 395d70 0f8689000000 833d????????06 752c 833d????????03 7434 }
            // n = 7, score = 100
            //   ff5554               | call                dword ptr [ebp + 0x54]
            //   395d70               | cmp                 dword ptr [ebp + 0x70], ebx
            //   0f8689000000         | jbe                 0x8f
            //   833d????????06       |                     
            //   752c                 | jne                 0x2e
            //   833d????????03       |                     
            //   7434                 | je                  0x36

        $sequence_5 = { 83ec08 3bc2 7769 8d4c2404 51 8d542404 }
            // n = 6, score = 100
            //   83ec08               | sub                 esp, 8
            //   3bc2                 | cmp                 eax, edx
            //   7769                 | ja                  0x6b
            //   8d4c2404             | lea                 ecx, [esp + 4]
            //   51                   | push                ecx
            //   8d542404             | lea                 edx, [esp + 4]

        $sequence_6 = { 50 e8???????? 0145f8 837df805 8945e8 72e7 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   0145f8               | add                 dword ptr [ebp - 8], eax
            //   837df805             | cmp                 dword ptr [ebp - 8], 5
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   72e7                 | jb                  0xffffffe9

        $sequence_7 = { 7814 8d5002 85d2 7406 8d440802 eb02 }
            // n = 6, score = 100
            //   7814                 | js                  0x16
            //   8d5002               | lea                 edx, [eax + 2]
            //   85d2                 | test                edx, edx
            //   7406                 | je                  8
            //   8d440802             | lea                 eax, [eax + ecx + 2]
            //   eb02                 | jmp                 4

        $sequence_8 = { 8b413c 53 03c1 0fb74814 56 0fb77006 33db }
            // n = 7, score = 100
            //   8b413c               | mov                 eax, dword ptr [ecx + 0x3c]
            //   53                   | push                ebx
            //   03c1                 | add                 eax, ecx
            //   0fb74814             | movzx               ecx, word ptr [eax + 0x14]
            //   56                   | push                esi
            //   0fb77006             | movzx               esi, word ptr [eax + 6]
            //   33db                 | xor                 ebx, ebx

        $sequence_9 = { 66890477 46 3bf3 72ea 33c0 66890477 }
            // n = 6, score = 100
            //   66890477             | mov                 word ptr [edi + esi*2], ax
            //   46                   | inc                 esi
            //   3bf3                 | cmp                 esi, ebx
            //   72ea                 | jb                  0xffffffec
            //   33c0                 | xor                 eax, eax
            //   66890477             | mov                 word ptr [edi + esi*2], ax

    condition:
        7 of them and filesize < 401408
}