rule win_latrodectus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.latrodectus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.latrodectus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b4c2430 8801 488b442430 48ffc0 4889442430 8b44242c }
            // n = 6, score = 6900
            //   488b4c2430           | mov                 dword ptr [esp + 0x20], eax
            //   8801                 | mov                 eax, dword ptr [esp + 0x20]
            //   488b442430           | dec                 eax
            //   48ffc0               | cmp                 eax, 0x25
            //   4889442430           | jae                 0x3c
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x20]

        $sequence_1 = { 33c0 6689842430010000 ba18000000 488d8c24d0000000 e8???????? 488d8424d0000000 }
            // n = 6, score = 6900
            //   33c0                 | mov                 dword ptr [esp + 0x30], 0x68
            //   6689842430010000     | xor                 eax, eax
            //   ba18000000           | mov                 word ptr [esp + 0x130], ax
            //   488d8c24d0000000     | mov                 edx, 0x18
            //   e8????????           |                     
            //   488d8424d0000000     | dec                 eax

        $sequence_2 = { 33c9 ff15???????? 488905???????? 48833d????????00 7414 }
            // n = 5, score = 6900
            //   33c9                 | dec                 eax
            //   ff15????????         |                     
            //   488905????????       |                     
            //   48833d????????00     |                     
            //   7414                 | imul                eax, eax, 0x18

        $sequence_3 = { 488b542458 488d4c2428 e8???????? 488b4c2458 e8???????? 488b442420 }
            // n = 6, score = 6900
            //   488b542458           | lea                 ecx, [esp + 0xd0]
            //   488d4c2428           | dec                 eax
            //   e8????????           |                     
            //   488b4c2458           | lea                 eax, [esp + 0xd0]
            //   e8????????           |                     
            //   488b442420           | dec                 eax

        $sequence_4 = { 488b00 488b4818 e8???????? 488b442430 488b00 4883782000 }
            // n = 6, score = 6900
            //   488b00               | mov                 edx, dword ptr [esp + 0x58]
            //   488b4818             | dec                 eax
            //   e8????????           |                     
            //   488b442430           | lea                 ecx, [esp + 0x28]
            //   488b00               | dec                 eax
            //   4883782000           | mov                 ecx, dword ptr [esp + 0x58]

        $sequence_5 = { 89442420 8b442420 4883f825 7336 8b442420 486bc018 }
            // n = 6, score = 6900
            //   89442420             | dec                 eax
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   4883f825             | dec                 eax
            //   7336                 | mov                 eax, dword ptr [eax]
            //   8b442420             | dec                 eax
            //   486bc018             | mov                 ecx, dword ptr [eax + 0x18]

        $sequence_6 = { 488bc1 488b4c2450 0fb709 488d0488 4889442438 488b442438 }
            // n = 6, score = 6900
            //   488bc1               | dec                 eax
            //   488b4c2450           | mov                 eax, dword ptr [esp + 0x30]
            //   0fb709               | dec                 eax
            //   488d0488             | mov                 eax, dword ptr [eax]
            //   4889442438           | dec                 eax
            //   488b442438           | cmp                 dword ptr [eax + 0x20], 0

        $sequence_7 = { e8???????? 89442420 ba68000000 488d4c2430 e8???????? c744243068000000 }
            // n = 6, score = 6900
            //   e8????????           |                     
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   ba68000000           | mov                 edx, 0x68
            //   488d4c2430           | dec                 eax
            //   e8????????           |                     
            //   c744243068000000     | lea                 ecx, [esp + 0x30]

        $sequence_8 = { 4883e808 4883f81f 0f87ab000000 e8???????? 488bc3 488b8dd0050000 }
            // n = 6, score = 100
            //   4883e808             | mov                 eax, 1
            //   4883f81f             | dec                 eax
            //   0f87ab000000         | imul                eax, eax, 1
            //   e8????????           |                     
            //   488bc3               | movzx               eax, byte ptr [esp + eax + 0x20]
            //   488b8dd0050000       | dec                 eax

        $sequence_9 = { 410fb6f0 e9???????? 80fb05 7405 80fb0b 7508 }
            // n = 6, score = 100
            //   410fb6f0             | dec                 eax
            //   e9????????           |                     
            //   80fb05               | mov                 dword ptr [esp + 0x20], edx
            //   7405                 | dec                 esp
            //   80fb0b               | lea                 eax, [0x62dfd]
            //   7508                 | ja                  0x3e2

        $sequence_10 = { 480f474d70 488b8580000000 4889442430 48894c2428 4889542420 4c8d05fd2d0600 }
            // n = 6, score = 100
            //   480f474d70           | sub                 eax, 8
            //   488b8580000000       | dec                 eax
            //   4889442430           | cmp                 eax, 0x1f
            //   48894c2428           | ja                  0xb5
            //   4889542420           | dec                 eax
            //   4c8d05fd2d0600       | mov                 eax, ebx

        $sequence_11 = { 4833c4 4889842448010000 498bf1 4d8bf0 8bfa 4c89442458 }
            // n = 6, score = 100
            //   4833c4               | sub                 esp, 0x30
            //   4889842448010000     | dec                 eax
            //   498bf1               | mov                 eax, dword ptr [esp + 0x60]
            //   4d8bf0               | dec                 ecx
            //   8bfa                 | mov                 edi, ecx
            //   4c89442458           | dec                 ecx

        $sequence_12 = { 41b826000000 488d1591b10b00 488d4c2430 e8???????? 90 488b7c2440 }
            // n = 6, score = 100
            //   41b826000000         | lfence              
            //   488d1591b10b00       | movdqu              xmmword ptr [esp + 0x78], xmm0
            //   488d4c2430           | inc                 sp
            //   e8????????           |                     
            //   90                   | mov                 dword ptr [esp + 0x68], esp
            //   488b7c2440           | dec                 eax

        $sequence_13 = { 4883ec30 488b442460 498bf9 492bf8 488bf2 482bf1 }
            // n = 6, score = 100
            //   4883ec30             | dec                 eax
            //   488b442460           | mov                 eax, dword ptr [ebp + 0x80]
            //   498bf9               | dec                 eax
            //   492bf8               | mov                 dword ptr [esp + 0x30], eax
            //   488bf2               | dec                 eax
            //   482bf1               | mov                 dword ptr [esp + 0x28], ecx

        $sequence_14 = { 0f87dc030000 0faee8 e8???????? 660f6f05???????? f30f7f442478 664489642468 }
            // n = 6, score = 100
            //   0f87dc030000         | dec                 eax
            //   0faee8               | mov                 ecx, dword ptr [ebp + 0x5d0]
            //   e8????????           |                     
            //   660f6f05????????     |                     
            //   f30f7f442478         | dec                 eax
            //   664489642468         | cmova               ecx, dword ptr [ebp + 0x70]

        $sequence_15 = { 0fb605???????? 884130 c6413100 0f57c0 0f11442438 488d3da9630d00 }
            // n = 6, score = 100
            //   0fb605????????       |                     
            //   884130               | sub                 edi, eax
            //   c6413100             | dec                 eax
            //   0f57c0               | mov                 esi, edx
            //   0f11442438           | dec                 eax
            //   488d3da9630d00       | sub                 esi, ecx

    condition:
        7 of them and filesize < 2467840
}