rule win_lazardoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lazardoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lazardoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4883c024 8938 e8???????? 488d1d23ce0100 }
            // n = 4, score = 200
            //   4883c024             | xor                 edx, edx
            //   8938                 | dec                 eax
            //   e8????????           |                     
            //   488d1d23ce0100       | lea                 eax, [esp + 0x48]

        $sequence_1 = { e8???????? ba50540000 488b0d???????? 4533c9 4533c0 ff15???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   ba50540000           | mov                 ecx, 0x40
            //   488b0d????????       |                     
            //   4533c9               | dec                 eax
            //   4533c0               | mov                 ebx, eax
            //   ff15????????         |                     

        $sequence_2 = { 4803cf e8???????? 488b0e 41ffc6 4883c328 }
            // n = 5, score = 200
            //   4803cf               | lea                 ecx, [0xc7a7]
            //   e8????????           |                     
            //   488b0e               | mov                 ebx, edx
            //   41ffc6               | dec                 esp
            //   4883c328             | lea                 eax, [0xc796]

        $sequence_3 = { 4889442420 498bd4 ff15???????? 85c0 7506 ff15???????? 4533f6 }
            // n = 7, score = 200
            //   4889442420           | mov                 edi, eax
            //   498bd4               | dec                 ecx
            //   ff15????????         |                     
            //   85c0                 | mov                 ecx, edi
            //   7506                 | dec                 eax
            //   ff15????????         |                     
            //   4533f6               | lea                 eax, [ebp - 0x70]

        $sequence_4 = { 4c8bb424d0010000 488b8dc0000000 4833cc e8???????? 4881c4e8010000 415f 415d }
            // n = 7, score = 200
            //   4c8bb424d0010000     | lea                 eax, [ebx + 3]
            //   488b8dc0000000       | mov                 dword ptr [esp + 0x28], ebx
            //   4833cc               | dec                 eax
            //   e8????????           |                     
            //   4881c4e8010000       | lea                 ecx, [0xa923]
            //   415f                 | inc                 ebp
            //   415d                 | xor                 ecx, ecx

        $sequence_5 = { 488d45e8 48894de8 488945f0 488d155cde0000 }
            // n = 4, score = 200
            //   488d45e8             | lea                 ecx, [0xfffffab1]
            //   48894de8             | mov                 dword ptr [esp + 0x20], 0x40
            //   488945f0             | dec                 eax
            //   488d155cde0000       | mov                 dword ptr [esp + 0x28], eax

        $sequence_6 = { 83c8ff f00fc103 83f801 7516 488d05a6470100 488b4c2430 483bc8 }
            // n = 7, score = 200
            //   83c8ff               | dec                 eax
            //   f00fc103             | dec                 edi
            //   83f801               | inc                 ecx
            //   7516                 | movzx               edx, bl
            //   488d05a6470100       | dec                 esp
            //   488b4c2430           | lea                 ecx, [0xc9b3]
            //   483bc8               | dec                 eax

        $sequence_7 = { 7873 3b1d???????? 736b 488bc3 488bf3 48c1fe06 4c8d2dbe0f0100 }
            // n = 7, score = 200
            //   7873                 | mov                 eax, 0x824
            //   3b1d????????         |                     
            //   736b                 | dec                 ecx
            //   488bc3               | lea                 ecx, [esi + 0x824]
            //   488bf3               | dec                 eax
            //   48c1fe06             | test                ecx, ecx
            //   4c8d2dbe0f0100       | jne                 0x1084

        $sequence_8 = { 488d1517c4feff c1e803 89442450 8bc8 89442448 }
            // n = 5, score = 200
            //   488d1517c4feff       | inc                 ebp
            //   c1e803               | xor                 esi, esi
            //   89442450             | dec                 eax
            //   8bc8                 | arpl                si, cx
            //   89442448             | dec                 eax

        $sequence_9 = { 488d15c2a20200 488bce ff15???????? 85c0 0f84f3000000 48c7c7ffffffff 488bc7 }
            // n = 7, score = 200
            //   488d15c2a20200       | add                 esp, 0x60
            //   488bce               | pop                 ebp
            //   ff15????????         |                     
            //   85c0                 | ret                 
            //   0f84f3000000         | dec                 eax
            //   48c7c7ffffffff       | mov                 dword ptr [esp + 0x70], ebx
            //   488bc7               | dec                 eax

    condition:
        7 of them and filesize < 405504
}