rule win_lazarus_killdisk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lazarus_killdisk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lazarus_killdisk"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d48e0 80f93f 7706 0fbec0 83c020 }
            // n = 5, score = 200
            //   8d48e0               | lea                 ecx, [eax - 0x20]
            //   80f93f               | cmp                 cl, 0x3f
            //   7706                 | ja                  8
            //   0fbec0               | movsx               eax, al
            //   83c020               | add                 eax, 0x20

        $sequence_1 = { 56 ffd7 4b 75ea 56 ff15???????? }
            // n = 6, score = 200
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   4b                   | dec                 ebx
            //   75ea                 | jne                 0xffffffec
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_2 = { 7438 8d55f0 52 68???????? }
            // n = 4, score = 200
            //   7438                 | je                  0x3a
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   52                   | push                edx
            //   68????????           |                     

        $sequence_3 = { 57 8d4c242c 68???????? 51 e8???????? }
            // n = 5, score = 200
            //   57                   | push                edi
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_4 = { 8d4402ff 0fa4c109 6a00 894df4 8d4df4 c1e009 }
            // n = 6, score = 200
            //   8d4402ff             | lea                 eax, [edx + eax - 1]
            //   0fa4c109             | shld                ecx, eax, 9
            //   6a00                 | push                0
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   8d4df4               | lea                 ecx, [ebp - 0xc]
            //   c1e009               | shl                 eax, 9

        $sequence_5 = { 6a00 8d85e0fdffff 50 6800020000 }
            // n = 4, score = 200
            //   6a00                 | push                0
            //   8d85e0fdffff         | lea                 eax, [ebp - 0x220]
            //   50                   | push                eax
            //   6800020000           | push                0x200

        $sequence_6 = { 6a00 6800000002 ffd3 8bf0 83feff }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   6800000002           | push                0x2000000
            //   ffd3                 | call                ebx
            //   8bf0                 | mov                 esi, eax
            //   83feff               | cmp                 esi, -1

        $sequence_7 = { eb08 8d5de8 e8???????? 8b85e4fdffff 40 83c610 8985e4fdffff }
            // n = 7, score = 200
            //   eb08                 | jmp                 0xa
            //   8d5de8               | lea                 ebx, [ebp - 0x18]
            //   e8????????           |                     
            //   8b85e4fdffff         | mov                 eax, dword ptr [ebp - 0x21c]
            //   40                   | inc                 eax
            //   83c610               | add                 esi, 0x10
            //   8985e4fdffff         | mov                 dword ptr [ebp - 0x21c], eax

        $sequence_8 = { 8d75a6 8b06 8b4e08 8b560c 8945e8 }
            // n = 5, score = 200
            //   8d75a6               | lea                 esi, [ebp - 0x5a]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   8b560c               | mov                 edx, dword ptr [esi + 0xc]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_9 = { ffd7 85c0 7424 68???????? 8d95e4feffff 52 }
            // n = 6, score = 200
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7424                 | je                  0x26
            //   68????????           |                     
            //   8d95e4feffff         | lea                 edx, [ebp - 0x11c]
            //   52                   | push                edx

    condition:
        7 of them and filesize < 209920
}