rule win_laziok_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.laziok."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.laziok"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 751a ff7610 ff15???????? 56 }
            // n = 4, score = 900
            //   751a                 | jne                 0x1c
            //   ff7610               | push                dword ptr [esi + 0x10]
            //   ff15????????         |                     
            //   56                   | push                esi

        $sequence_1 = { 59 85c0 740a 8b4c240c 8b742408 8901 }
            // n = 6, score = 900
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   8b742408             | mov                 esi, dword ptr [esp + 8]
            //   8901                 | mov                 dword ptr [ecx], eax

        $sequence_2 = { 8bc6 5e c20800 55 8bec 81ec04010000 }
            // n = 6, score = 900
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c20800               | ret                 8
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec04010000         | sub                 esp, 0x104

        $sequence_3 = { 668945f0 8b4604 8945f4 0fb74608 }
            // n = 4, score = 900
            //   668945f0             | mov                 word ptr [ebp - 0x10], ax
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   0fb74608             | movzx               eax, word ptr [esi + 8]

        $sequence_4 = { ff74240c 33f6 ff35???????? e8???????? }
            // n = 4, score = 900
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   33f6                 | xor                 esi, esi
            //   ff35????????         |                     
            //   e8????????           |                     

        $sequence_5 = { 668945f2 8b460c 85c0 7404 8b00 eb03 }
            // n = 6, score = 900
            //   668945f2             | mov                 word ptr [ebp - 0xe], ax
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]
            //   85c0                 | test                eax, eax
            //   7404                 | je                  6
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   eb03                 | jmp                 5

        $sequence_6 = { 7513 6a00 ff7510 ff750c ff7608 ff15???????? eb3f }
            // n = 7, score = 900
            //   7513                 | jne                 0x15
            //   6a00                 | push                0
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7608               | push                dword ptr [esi + 8]
            //   ff15????????         |                     
            //   eb3f                 | jmp                 0x41

        $sequence_7 = { e8???????? 59 59 85c0 740d 3bc7 }
            // n = 6, score = 900
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   740d                 | je                  0xf
            //   3bc7                 | cmp                 eax, edi

    condition:
        7 of them and filesize < 688128
}