rule win_leouncia_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.leouncia."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.leouncia"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 c644141800 ff15???????? 85c0 7512 ff15???????? 83f805 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   c644141800           | mov                 byte ptr [esp + edx + 0x18], 0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7512                 | jne                 0x14
            //   ff15????????         |                     
            //   83f805               | cmp                 eax, 5

        $sequence_1 = { 3bf3 7519 8b35???????? 55 }
            // n = 4, score = 100
            //   3bf3                 | cmp                 esi, ebx
            //   7519                 | jne                 0x1b
            //   8b35????????         |                     
            //   55                   | push                ebp

        $sequence_2 = { 895c2464 ff15???????? 85c0 7520 }
            // n = 4, score = 100
            //   895c2464             | mov                 dword ptr [esp + 0x64], ebx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7520                 | jne                 0x22

        $sequence_3 = { 8dbc247c040000 2bd6 8bca 89542418 8be9 c1e902 f3a5 }
            // n = 7, score = 100
            //   8dbc247c040000       | lea                 edi, [esp + 0x47c]
            //   2bd6                 | sub                 edx, esi
            //   8bca                 | mov                 ecx, edx
            //   89542418             | mov                 dword ptr [esp + 0x18], edx
            //   8be9                 | mov                 ebp, ecx
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_4 = { 7505 c6440c2820 41 3bc8 7cee 8b842434050000 56 }
            // n = 7, score = 100
            //   7505                 | jne                 7
            //   c6440c2820           | mov                 byte ptr [esp + ecx + 0x28], 0x20
            //   41                   | inc                 ecx
            //   3bc8                 | cmp                 ecx, eax
            //   7cee                 | jl                  0xfffffff0
            //   8b842434050000       | mov                 eax, dword ptr [esp + 0x534]
            //   56                   | push                esi

        $sequence_5 = { 50 e8???????? 8d4c2424 51 e8???????? 8b2d???????? 83c410 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b2d????????         |                     
            //   83c410               | add                 esp, 0x10

        $sequence_6 = { e8???????? 8b4c2420 83c40c 889c0c14010000 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   83c40c               | add                 esp, 0xc
            //   889c0c14010000       | mov                 byte ptr [esp + ecx + 0x114], bl

        $sequence_7 = { 8d542440 8d442450 8d8c24b4040000 52 }
            // n = 4, score = 100
            //   8d542440             | lea                 edx, [esp + 0x40]
            //   8d442450             | lea                 eax, [esp + 0x50]
            //   8d8c24b4040000       | lea                 ecx, [esp + 0x4b4]
            //   52                   | push                edx

        $sequence_8 = { 8b0f 52 50 51 6a00 ff15???????? }
            // n = 6, score = 100
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   52                   | push                edx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_9 = { 89942444040000 8b542434 8bc1 8bf5 }
            // n = 4, score = 100
            //   89942444040000       | mov                 dword ptr [esp + 0x444], edx
            //   8b542434             | mov                 edx, dword ptr [esp + 0x34]
            //   8bc1                 | mov                 eax, ecx
            //   8bf5                 | mov                 esi, ebp

    condition:
        7 of them and filesize < 114688
}