rule win_lightbunny_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lightbunny."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lightbunny"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c9 b8???????? 90 3910 7412 0524100000 }
            // n = 6, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   b8????????           |                     
            //   90                   | nop                 
            //   3910                 | cmp                 dword ptr [eax], edx
            //   7412                 | je                  0x14
            //   0524100000           | add                 eax, 0x1024

        $sequence_1 = { e8???????? 8b55f4 83c404 b906000000 e8???????? e9???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   83c404               | add                 esp, 4
            //   b906000000           | mov                 ecx, 6
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_2 = { 6a32 ff15???????? 8bcf e8???????? 8bf0 85f6 75e2 }
            // n = 7, score = 100
            //   6a32                 | push                0x32
            //   ff15????????         |                     
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   75e2                 | jne                 0xffffffe4

        $sequence_3 = { 8d0485586e4100 50 8d8590faffff 03c7 50 e8???????? }
            // n = 6, score = 100
            //   8d0485586e4100       | lea                 eax, [eax*4 + 0x416e58]
            //   50                   | push                eax
            //   8d8590faffff         | lea                 eax, [ebp - 0x570]
            //   03c7                 | add                 eax, edi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_4 = { ff36 894608 68???????? e8???????? 83c408 }
            // n = 5, score = 100
            //   ff36                 | push                dword ptr [esi]
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   68????????           |                     
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_5 = { 83b81810000000 0f85defeffff 83b82010000000 0f85d1feffff 6a00 }
            // n = 5, score = 100
            //   83b81810000000       | cmp                 dword ptr [eax + 0x1018], 0
            //   0f85defeffff         | jne                 0xfffffee4
            //   83b82010000000       | cmp                 dword ptr [eax + 0x1020], 0
            //   0f85d1feffff         | jne                 0xfffffed7
            //   6a00                 | push                0

        $sequence_6 = { ff75f4 68???????? e8???????? 8b4df4 83c40c }
            // n = 5, score = 100
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   68????????           |                     
            //   e8????????           |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   83c40c               | add                 esp, 0xc

        $sequence_7 = { c1f906 53 6bd830 56 8b048d20ae4100 }
            // n = 5, score = 100
            //   c1f906               | sar                 ecx, 6
            //   53                   | push                ebx
            //   6bd830               | imul                ebx, eax, 0x30
            //   56                   | push                esi
            //   8b048d20ae4100       | mov                 eax, dword ptr [ecx*4 + 0x41ae20]

        $sequence_8 = { 69f224100000 81c6???????? 7410 c7460404000000 ff15???????? }
            // n = 5, score = 100
            //   69f224100000         | imul                esi, edx, 0x1024
            //   81c6????????         |                     
            //   7410                 | je                  0x12
            //   c7460404000000       | mov                 dword ptr [esi + 4], 4
            //   ff15????????         |                     

        $sequence_9 = { 8b148520ae4100 8a4c1a2d f6c104 7419 8a441a2e 80e1fb }
            // n = 6, score = 100
            //   8b148520ae4100       | mov                 edx, dword ptr [eax*4 + 0x41ae20]
            //   8a4c1a2d             | mov                 cl, byte ptr [edx + ebx + 0x2d]
            //   f6c104               | test                cl, 4
            //   7419                 | je                  0x1b
            //   8a441a2e             | mov                 al, byte ptr [edx + ebx + 0x2e]
            //   80e1fb               | and                 cl, 0xfb

    condition:
        7 of them and filesize < 2376704
}