rule win_lightneuron_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lightneuron."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lightneuron"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b0d???????? 4885d2 480f45ca ff15???????? 488b4b08 8d5001 e8???????? }
            // n = 7, score = 100
            //   488b0d????????       |                     
            //   4885d2               | dec                 eax
            //   480f45ca             | mov                 eax, ebx
            //   ff15????????         |                     
            //   488b4b08             | dec                 eax
            //   8d5001               | mov                 ebx, dword ptr [esp + 0x38]
            //   e8????????           |                     

        $sequence_1 = { 448830 e8???????? 85c0 744e 488bcb e8???????? 41ffc4 }
            // n = 7, score = 100
            //   448830               | test                eax, eax
            //   e8????????           |                     
            //   85c0                 | dec                 esp
            //   744e                 | cmovne              eax, eax
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   41ffc4               | lea                 eax, [esp + 0x58]

        $sequence_2 = { 488bd3 4c0f45c8 488b05???????? 488bcf 4885c0 4c0f45c0 e8???????? }
            // n = 7, score = 100
            //   488bd3               | dec                 esp
            //   4c0f45c8             | lea                 ecx, [esp + 0x40]
            //   488b05????????       |                     
            //   488bcf               | dec                 esp
            //   4885c0               | mov                 eax, esi
            //   4c0f45c0             | dec                 eax
            //   e8????????           |                     

        $sequence_3 = { c744244801000000 85ff 0f8598080000 488b8c24d8000000 4883f901 7304 33c0 }
            // n = 7, score = 100
            //   c744244801000000     | idiv                ecx
            //   85ff                 | mov                 ecx, eax
            //   0f8598080000         | mov                 eax, dword ptr [esp + 0x40]
            //   488b8c24d8000000     | inc                 esp
            //   4883f901             | lea                 ecx, [eax + ecx + 0x10]
            //   7304                 | inc                 esp
            //   33c0                 | mov                 eax, dword ptr [esp + 0x40]

        $sequence_4 = { 2bd8 78ef 4863db 488bd5 4803de 488bcb }
            // n = 6, score = 100
            //   2bd8                 | mov                 ebp, dword ptr [esp + 0xf8]
            //   78ef                 | dec                 eax
            //   4863db               | add                 esp, 0x110
            //   488bd5               | inc                 ecx
            //   4803de               | pop                 edi
            //   488bcb               | inc                 ecx

        $sequence_5 = { e8???????? 488bc7 41be01000000 458d4603 33d2 488bcf 4c89742470 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bc7               | shr                 eax, 0x10
            //   41be01000000         | movzx               ecx, al
            //   458d4603             | inc                 ecx
            //   33d2                 | movzx               eax, cl
            //   488bcf               | inc                 ebp
            //   4c89742470           | xor                 eax, dword ptr [esi + ecx*4 + 0x3e1c0]

        $sequence_6 = { 4883ec38 488b4c2440 ff15???????? 89442420 837c2420ff 7507 }
            // n = 6, score = 100
            //   4883ec38             | mov                 ecx, dword ptr [edi + 0xa8]
            //   488b4c2440           | dec                 esp
            //   ff15????????         |                     
            //   89442420             | mov                 dword ptr [esp + 0x40], esi
            //   837c2420ff           | dec                 esp
            //   7507                 | lea                 eax, [esp + 0x60]

        $sequence_7 = { 4885ed 7437 4885c0 7432 488d7501 483bf0 7729 }
            // n = 7, score = 100
            //   4885ed               | mov                 dword ptr [esp + 0x30], 0xffffffff
            //   7437                 | mov                 eax, dword ptr [esp + 0x30]
            //   4885c0               | dec                 eax
            //   7432                 | mov                 ecx, dword ptr [esp + 0x50]
            //   488d7501             | mov                 dword ptr [esp + 0x20], eax
            //   483bf0               | dec                 eax
            //   7729                 | mov                 ecx, dword ptr [esp + 0x58]

        $sequence_8 = { 0fb6c8 410fb6c1 339c8dc0e90300 339c8580d50300 418bc1 41c1e910 41335d04 }
            // n = 7, score = 100
            //   0fb6c8               | inc                 ecx
            //   410fb6c1             | movzx               eax, dl
            //   339c8dc0e90300       | inc                 ebp
            //   339c8580d50300       | xor                 eax, dword ptr [esi + eax*4 + 0x3f1c0]
            //   418bc1               | inc                 ecx
            //   41c1e910             | mov                 eax, ecx
            //   41335d04             | inc                 ebp

        $sequence_9 = { 4c89742428 4489742420 e8???????? 418bee 488b05???????? 488b15???????? }
            // n = 6, score = 100
            //   4c89742428           | shr                 eax, 0xe
            //   4489742420           | mov                 ecx, eax
            //   e8????????           |                     
            //   418bee               | dec                 eax
            //   488b05????????       |                     
            //   488b15????????       |                     

    condition:
        7 of them and filesize < 573440
}