rule win_lightwork_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lightwork."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lightwork"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d5001 8b4508 8990c8010000 8b4508 890424 e8???????? 8b4508 }
            // n = 7, score = 100
            //   8d5001               | lea                 edx, [eax + 1]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8990c8010000         | mov                 dword ptr [eax + 0x1c8], edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_1 = { 83e0e0 89c2 8b450c 83e01f 09d0 }
            // n = 5, score = 100
            //   83e0e0               | and                 eax, 0xffffffe0
            //   89c2                 | mov                 edx, eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   83e01f               | and                 eax, 0x1f
            //   09d0                 | or                  eax, edx

        $sequence_2 = { c3 55 89e5 8b4508 83c011 5d c3 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83c011               | add                 eax, 0x11
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_3 = { e8???????? 69d0e8030000 8b450c 01d0 8945f4 8b45f4 89c2 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   69d0e8030000         | imul                edx, eax, 0x3e8
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   01d0                 | add                 eax, edx
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   89c2                 | mov                 edx, eax

        $sequence_4 = { 8b80d8010000 8b5510 89542408 8b550c 89542404 890424 e8???????? }
            // n = 7, score = 100
            //   8b80d8010000         | mov                 eax, dword ptr [eax + 0x1d8]
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   89542408             | mov                 dword ptr [esp + 8], edx
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   89542404             | mov                 dword ptr [esp + 4], edx
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_5 = { 7419 8b45f0 8b55f4 89442404 89542408 8b4508 890424 }
            // n = 7, score = 100
            //   7419                 | je                  0x1b
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   89542408             | mov                 dword ptr [esp + 8], edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_6 = { 55 89e5 8b4508 0fb64005 83e0f0 89c2 8b450c }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0fb64005             | movzx               eax, byte ptr [eax + 5]
            //   83e0f0               | and                 eax, 0xfffffff0
            //   89c2                 | mov                 edx, eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_7 = { 89e5 8b4508 c74008???????? 8b4508 c740047d000000 90 5d }
            // n = 7, score = 100
            //   89e5                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c74008????????       |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c740047d000000       | mov                 dword ptr [eax + 4], 0x7d
            //   90                   | nop                 
            //   5d                   | pop                 ebp

        $sequence_8 = { 890424 e8???????? 8b450c 8b4014 014518 8b5518 8b4510 }
            // n = 7, score = 100
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4014               | mov                 eax, dword ptr [eax + 0x14]
            //   014518               | add                 dword ptr [ebp + 0x18], eax
            //   8b5518               | mov                 edx, dword ptr [ebp + 0x18]
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_9 = { 66894819 0fb65206 88501b 8b4508 c9 c3 55 }
            // n = 7, score = 100
            //   66894819             | mov                 word ptr [eax + 0x19], cx
            //   0fb65206             | movzx               edx, byte ptr [edx + 6]
            //   88501b               | mov                 byte ptr [eax + 0x1b], dl
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp

    condition:
        7 of them and filesize < 1132544
}