rule win_lilith_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lilith."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lilith"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81784800374300 7409 ff7048 e8???????? 59 c70701000000 8bcf }
            // n = 7, score = 200
            //   81784800374300       | cmp                 dword ptr [eax + 0x48], 0x433700
            //   7409                 | je                  0xb
            //   ff7048               | push                dword ptr [eax + 0x48]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   c70701000000         | mov                 dword ptr [edi], 1
            //   8bcf                 | mov                 ecx, edi

        $sequence_1 = { 8b7d08 8bd9 33f6 0f1f00 6a00 }
            // n = 5, score = 200
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8bd9                 | mov                 ebx, ecx
            //   33f6                 | xor                 esi, esi
            //   0f1f00               | nop                 dword ptr [eax]
            //   6a00                 | push                0

        $sequence_2 = { e8???????? 8d4dd4 e8???????? 83c418 b9???????? 50 e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   b9????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { 57 56 ff15???????? ff75a0 8b35???????? ffd6 ff75a4 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   ff75a0               | push                dword ptr [ebp - 0x60]
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   ff75a4               | push                dword ptr [ebp - 0x5c]

        $sequence_4 = { 33c0 663b8880974200 740d 83c002 }
            // n = 4, score = 200
            //   33c0                 | xor                 eax, eax
            //   663b8880974200       | cmp                 cx, word ptr [eax + 0x429780]
            //   740d                 | je                  0xf
            //   83c002               | add                 eax, 2

        $sequence_5 = { 8d3c85d04a4300 8b0f 85c9 740b 8d4101 f7d8 1bc0 }
            // n = 7, score = 200
            //   8d3c85d04a4300       | lea                 edi, [eax*4 + 0x434ad0]
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   85c9                 | test                ecx, ecx
            //   740b                 | je                  0xd
            //   8d4101               | lea                 eax, [ecx + 1]
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax

        $sequence_6 = { 8d4dd4 50 e8???????? 8d4db4 e8???????? }
            // n = 5, score = 200
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4db4               | lea                 ecx, [ebp - 0x4c]
            //   e8????????           |                     

        $sequence_7 = { c7411400000000 6a00 c741140f000000 c7411000000000 68???????? 8801 }
            // n = 6, score = 200
            //   c7411400000000       | mov                 dword ptr [ecx + 0x14], 0
            //   6a00                 | push                0
            //   c741140f000000       | mov                 dword ptr [ecx + 0x14], 0xf
            //   c7411000000000       | mov                 dword ptr [ecx + 0x10], 0
            //   68????????           |                     
            //   8801                 | mov                 byte ptr [ecx], al

        $sequence_8 = { c745fc00000000 0f57c0 6a00 50 }
            // n = 4, score = 200
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   0f57c0               | xorps               xmm0, xmm0
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_9 = { e8???????? 8b0d???????? e8???????? eb10 ff75dc 8b35???????? ffd6 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   e8????????           |                     
            //   eb10                 | jmp                 0x12
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   8b35????????         |                     
            //   ffd6                 | call                esi

    condition:
        7 of them and filesize < 499712
}