rule win_linseningsvr_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.linseningsvr."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.linseningsvr"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 8dbc24dd090000 c644241000 f3ab 66ab aa }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   8dbc24dd090000       | lea                 edi, [esp + 0x9dd]
            //   c644241000           | mov                 byte ptr [esp + 0x10], 0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al

        $sequence_1 = { 8d542464 6a01 52 89442464 894c2468 e8???????? }
            // n = 6, score = 100
            //   8d542464             | lea                 edx, [esp + 0x64]
            //   6a01                 | push                1
            //   52                   | push                edx
            //   89442464             | mov                 dword ptr [esp + 0x64], eax
            //   894c2468             | mov                 dword ptr [esp + 0x68], ecx
            //   e8????????           |                     

        $sequence_2 = { 8dbc24dd090000 c644241000 f3ab 66ab }
            // n = 4, score = 100
            //   8dbc24dd090000       | lea                 edi, [esp + 0x9dd]
            //   c644241000           | mov                 byte ptr [esp + 0x10], 0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax

        $sequence_3 = { 8b0485c08d4000 03c6 8a5004 f6c201 }
            // n = 4, score = 100
            //   8b0485c08d4000       | mov                 eax, dword ptr [eax*4 + 0x408dc0]
            //   03c6                 | add                 eax, esi
            //   8a5004               | mov                 dl, byte ptr [eax + 4]
            //   f6c201               | test                dl, 1

        $sequence_4 = { e8???????? 57 e8???????? 83c418 8d44244c }
            // n = 5, score = 100
            //   e8????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   8d44244c             | lea                 eax, [esp + 0x4c]

        $sequence_5 = { 742e 85f6 7419 0fb6da f683818c400004 }
            // n = 5, score = 100
            //   742e                 | je                  0x30
            //   85f6                 | test                esi, esi
            //   7419                 | je                  0x1b
            //   0fb6da               | movzx               ebx, dl
            //   f683818c400004       | test                byte ptr [ebx + 0x408c81], 4

        $sequence_6 = { c705????????01000000 50 a3???????? e8???????? 8db6bc884000 }
            // n = 5, score = 100
            //   c705????????01000000     |     
            //   50                   | push                eax
            //   a3????????           |                     
            //   e8????????           |                     
            //   8db6bc884000         | lea                 esi, [esi + 0x4088bc]

        $sequence_7 = { e8???????? 83c40c c3 53 56 be???????? 57 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   56                   | push                esi
            //   be????????           |                     
            //   57                   | push                edi

        $sequence_8 = { 8a4c3c4c 51 68???????? e8???????? 83c408 }
            // n = 5, score = 100
            //   8a4c3c4c             | mov                 cl, byte ptr [esp + edi + 0x4c]
            //   51                   | push                ecx
            //   68????????           |                     
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_9 = { e8???????? 83c404 ebc2 8b0d???????? 68???????? 51 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   ebc2                 | jmp                 0xffffffc4
            //   8b0d????????         |                     
            //   68????????           |                     
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 81360
}