rule win_liteduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.liteduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.liteduke"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c9 c20400 55 89e5 ff7508 6800010000 }
            // n = 6, score = 200
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   ff7508               | push                dword ptr [ebp + 8]
            //   6800010000           | push                0x100

        $sequence_1 = { 51 6821020000 50 6a21 50 6888c00700 ffb5d0fdffff }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   6821020000           | push                0x221
            //   50                   | push                eax
            //   6a21                 | push                0x21
            //   50                   | push                eax
            //   6888c00700           | push                0x7c088
            //   ffb5d0fdffff         | push                dword ptr [ebp - 0x230]

        $sequence_2 = { ad 6a04 59 c1c008 3c3d 7501 45 }
            // n = 7, score = 200
            //   ad                   | lodsd               eax, dword ptr [esi]
            //   6a04                 | push                4
            //   59                   | pop                 ecx
            //   c1c008               | rol                 eax, 8
            //   3c3d                 | cmp                 al, 0x3d
            //   7501                 | jne                 3
            //   45                   | inc                 ebp

        $sequence_3 = { 837d1001 7510 c745f810000000 c745fc0a000000 eb2a 837d1002 7510 }
            // n = 7, score = 200
            //   837d1001             | cmp                 dword ptr [ebp + 0x10], 1
            //   7510                 | jne                 0x12
            //   c745f810000000       | mov                 dword ptr [ebp - 8], 0x10
            //   c745fc0a000000       | mov                 dword ptr [ebp - 4], 0xa
            //   eb2a                 | jmp                 0x2c
            //   837d1002             | cmp                 dword ptr [ebp + 0x10], 2
            //   7510                 | jne                 0x12

        $sequence_4 = { f70600000080 7409 8b06 25ffffff3f eb60 50 e8???????? }
            // n = 7, score = 200
            //   f70600000080         | test                dword ptr [esi], 0x80000000
            //   7409                 | je                  0xb
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   25ffffff3f           | and                 eax, 0x3fffffff
            //   eb60                 | jmp                 0x62
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 8a03 52 50 6a03 e8???????? 83c408 5a }
            // n = 7, score = 200
            //   8a03                 | mov                 al, byte ptr [ebx]
            //   52                   | push                edx
            //   50                   | push                eax
            //   6a03                 | push                3
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   5a                   | pop                 edx

        $sequence_6 = { 7404 0113 ebca 2113 ebc6 58 }
            // n = 6, score = 200
            //   7404                 | je                  6
            //   0113                 | add                 dword ptr [ebx], edx
            //   ebca                 | jmp                 0xffffffcc
            //   2113                 | and                 dword ptr [ebx], edx
            //   ebc6                 | jmp                 0xffffffc8
            //   58                   | pop                 eax

        $sequence_7 = { 50 ff15???????? 83c410 ff75e4 e8???????? 6800800000 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c410               | add                 esp, 0x10
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   e8????????           |                     
            //   6800800000           | push                0x8000

        $sequence_8 = { e8???????? 31c0 aa 61 c9 c20c00 55 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   31c0                 | xor                 eax, eax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   61                   | popal               
            //   c9                   | leave               
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp

        $sequence_9 = { 21df 89d0 21f0 09f8 01c1 034dec }
            // n = 6, score = 200
            //   21df                 | and                 edi, ebx
            //   89d0                 | mov                 eax, edx
            //   21f0                 | and                 eax, esi
            //   09f8                 | or                  eax, edi
            //   01c1                 | add                 ecx, eax
            //   034dec               | add                 ecx, dword ptr [ebp - 0x14]

    condition:
        7 of them and filesize < 1171456
}